/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.irc.Messages;
import org.eclipse.ecf.internal.provider.irc.container.IRCAbstractContainer;
import org.eclipse.ecf.internal.provider.irc.container.IRCRootContainer;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.equinox.concurrent.future.TimeoutException;
import org.eclipse.osgi.util.NLS;
import org.schwering.irc.lib.IRCUser;

public class IRCChannelContainer
extends IRCAbstractContainer
implements IChatMessageSender,
IChatRoomContainer {
    private static final long CONNECT_TIMEOUT = new Long(System.getProperty("org.eclipse.ecf.provider.irc.connectTimeout", "60000"));
    protected List participantListeners = new ArrayList();
    protected IRCRootContainer rootContainer;
    protected IRCUser ircUser = null;
    protected String channelOperator;
    protected Object connectLock = new Object();
    protected boolean connectWaiting = false;
    protected Vector channelParticipants = new Vector();
    protected IChatRoomAdminSender adminSender = null;
    protected IChatRoomMessageSender sender = new IChatRoomMessageSender(){

        public void sendMessage(String message) throws ECFException {
            IRCChannelContainer.this.rootContainer.doSendChannelMessage(IRCChannelContainer.this.targetID.getName(), IRCChannelContainer.this.ircUser.toString(), message);
        }
    };

    public IRCChannelContainer(IRCRootContainer root, ID localID) {
        this.rootContainer = root;
        this.localID = localID;
    }

    public void addChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
        this.participantListeners.add(participantListener);
    }

    public void removeChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
        this.participantListeners.remove(participantListener);
    }

    protected void handleUserQuit(String name) {
        if (this.containsChannelParticipant(this.createIDFromString(name)) != null) {
            this.firePresenceListeners(false, new String[]{name});
        }
    }

    private IPresence createPresence(final boolean available) {
        return new IPresence(){
            private static final long serialVersionUID = -7514227760059471898L;
            Map properties = new HashMap();

            public IPresence.Mode getMode() {
                return available ? IPresence.Mode.AVAILABLE : IPresence.Mode.AWAY;
            }

            public Map getProperties() {
                return this.properties;
            }

            public String getStatus() {
                return null;
            }

            public IPresence.Type getType() {
                return available ? IPresence.Type.AVAILABLE : IPresence.Type.UNAVAILABLE;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public byte[] getPictureData() {
                return new byte[0];
            }
        };
    }

    protected boolean addChannelParticipant(ID participantID) {
        if (this.containsChannelParticipant(participantID) == null) {
            this.channelParticipants.add(participantID);
            return true;
        }
        return false;
    }

    protected ID removeChannelParticipant(ID participantID) {
        if (this.channelParticipants.remove(participantID)) {
            return participantID;
        }
        ID operatorID = this.createIDFromString("@" + participantID.getName());
        if (this.channelParticipants.remove(operatorID)) {
            return operatorID;
        }
        return null;
    }

    protected ID containsChannelParticipant(ID participantID) {
        if (this.channelParticipants.contains(participantID)) {
            return participantID;
        }
        ID operatorID = this.createIDFromString("@" + participantID.getName());
        if (this.channelParticipants.contains(operatorID)) {
            return operatorID;
        }
        return null;
    }

    protected void firePresenceListeners(boolean joined, String[] users) {
        int j = 0;
        while (j < users.length) {
            if (joined) {
                ID participantID;
                if (this.isChannelOperator(users[j])) {
                    this.setChannelOperator(users[j]);
                }
                if (this.addChannelParticipant(participantID = this.createIDFromString(users[j]))) {
                    for (IChatRoomParticipantListener l : this.participantListeners) {
                        l.handleArrived((IUser)new User(participantID));
                        l.handlePresenceUpdated(participantID, this.createPresence(true));
                    }
                }
            } else {
                ID removeID = this.removeChannelParticipant(this.createIDFromString(users[j]));
                if (removeID != null) {
                    for (IChatRoomParticipantListener l : this.participantListeners) {
                        l.handlePresenceUpdated(removeID, this.createPresence(false));
                        l.handleDeparted((IUser)new User(removeID));
                    }
                }
            }
            ++j;
        }
    }

    protected boolean isChannelOperator(String user) {
        return user != null && user.startsWith("@");
    }

    public IChatRoomMessageSender getChatRoomMessageSender() {
        return this.sender;
    }

    protected String getIRCUserName(IRCUser user) {
        return user == null ? null : user.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIRCUser(IRCUser user) {
        if (this.ircUser == null) {
            this.ircUser = user;
            Object object = this.connectLock;
            synchronized (object) {
                if (this.connectWaiting) {
                    this.connectWaiting = false;
                    this.connectLock.notify();
                }
            }
        } else {
            this.firePresenceListeners(true, new String[]{this.getIRCUserName(user)});
        }
    }

    protected void fireContainerEvent(IContainerEvent event) {
        super.fireContainerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID connectID, IConnectContext connectContext) throws ContainerConnectException {
        if (connectID == null) {
            throw new ContainerConnectException(Messages.IRCChannelContainer_Exception_TargetID_Null);
        }
        if (this.connectWaiting) {
            throw new ContainerConnectException(Messages.IRCChannelContainer_Exception_Connecting);
        }
        String channelName = connectID.getName();
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), connectID, (Object)connectContext));
        String pw = this.getPasswordFromConnectContext(connectContext);
        Object object = this.connectLock;
        synchronized (object) {
            this.connectWaiting = true;
            try {
                try {
                    this.rootContainer.doJoinChannel(channelName, pw);
                    long timeout = CONNECT_TIMEOUT + System.currentTimeMillis();
                    while (this.connectWaiting && timeout > System.currentTimeMillis()) {
                        this.connectLock.wait(2000L);
                    }
                    if (this.connectWaiting) {
                        throw new TimeoutException(NLS.bind((String)Messages.IRCChannelContainer_Exception_Connect_Timeout, (Object)connectID.getName()), CONNECT_TIMEOUT);
                    }
                    this.targetID = connectID;
                    this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), this.targetID));
                }
                catch (Exception e) {
                    this.targetID = null;
                    throw new ContainerConnectException(NLS.bind((String)Messages.IRCChannelContainer_Exception_Connect_Failed, (Object)connectID.getName()), (Throwable)e);
                }
            }
            finally {
                this.connectWaiting = false;
            }
        }
    }

    @Override
    public void disconnect() {
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), this.targetID));
        if (this.targetID != null) {
            this.rootContainer.doPartChannel(this.targetID.getName());
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), this.targetID));
    }

    public Object getAdapter(Class serviceType) {
        if (serviceType != null && serviceType.isInstance((Object)this)) {
            return this;
        }
        return null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(StringID.class.getName());
    }

    protected boolean isLocalUserChannelOperator() {
        return this.channelOperator != null && this.isLocalUserChannelOperator(this.channelOperator);
    }

    protected boolean isLocalUserChannelOperator(String chOperator) {
        String localUserName;
        if (!this.isChannelOperator(chOperator)) {
            return false;
        }
        String string = localUserName = this.ircUser == null ? null : "@" + this.ircUser.getNick();
        if (localUserName == null) {
            return false;
        }
        return chOperator.equals(localUserName);
    }

    protected void setChannelOperator(String channelOperator) {
        this.channelOperator = channelOperator;
    }

    public void sendChatMessage(ID toID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
        this.rootContainer.sendChatMessage(toID, body);
    }

    public void sendChatMessage(ID toID, String body) throws ECFException {
        this.rootContainer.sendChatMessage(toID, body);
    }

    public IChatMessageSender getPrivateMessageSender() {
        return this;
    }

    public ID[] getChatRoomParticipants() {
        return this.channelParticipants.toArray(new ID[this.channelParticipants.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChatRoomAdminSender getChatRoomAdminSender() {
        IRCChannelContainer iRCChannelContainer = this;
        synchronized (iRCChannelContainer) {
            if (this.adminSender == null) {
                this.adminSender = new IChatRoomAdminSender(){

                    public void sendSubjectChange(String newsubject) throws ECFException {
                        IRCChannelContainer.this.rootContainer.doSendSubjectChangeMessage(IRCChannelContainer.this.targetID.getName(), newsubject);
                    }
                };
            }
        }
        return this.adminSender;
    }
}

