/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.query;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.StatementResult;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.query.InternalStatement;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.query.QueryStatementResultImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import oracle.kv.query.BoundStatement;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;

public class BoundStatementImpl
implements BoundStatement,
InternalStatement {
    private final PreparedStatementImpl preparedStatement;
    private final Map<String, FieldValue> bindVariables;

    BoundStatementImpl(PreparedStatementImpl preparedStatement) {
        this.preparedStatement = preparedStatement;
        this.bindVariables = new HashMap<String, FieldValue>();
    }

    PreparedStatementImpl getPreparedStmt() {
        return this.preparedStatement;
    }

    public String toString() {
        return this.preparedStatement.toString();
    }

    @Override
    public RecordDef getResultDef() {
        return this.preparedStatement.getResultDef();
    }

    @Override
    public Map<String, FieldDef> getVariableTypes() {
        return this.preparedStatement.getExternalVarsTypes();
    }

    @Override
    public FieldDef getVariableType(String name) {
        return this.preparedStatement.getExternalVarType(name);
    }

    @Override
    public Map<String, FieldValue> getVariables() {
        return this.bindVariables;
    }

    @Override
    public BoundStatement createBoundStatement() {
        return this.preparedStatement.createBoundStatement();
    }

    @Override
    public BoundStatement setVariable(String name, FieldValue value) {
        this.validate(name, value);
        this.bindVariables.put(name, value);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, int value) {
        IntegerValueImpl val = FieldDefImpl.integerDef.createInteger(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, boolean value) {
        BooleanValueImpl val = FieldDefImpl.booleanDef.createBoolean(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, double value) {
        DoubleValueImpl val = FieldDefImpl.doubleDef.createDouble(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, float value) {
        FloatValueImpl val = FieldDefImpl.floatDef.createFloat(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, long value) {
        LongValueImpl val = FieldDefImpl.longDef.createLong(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, String value) {
        StringValueImpl val = FieldDefImpl.stringDef.createString(value);
        this.setVariable(name, val);
        return this;
    }

    @Override
    public BoundStatement setVariable(String name, byte[] value) {
        BinaryValueImpl val = FieldDefImpl.binaryDef.createBinary(value);
        this.setVariable(name, val);
        return this;
    }

    private void validate(String varName, FieldValue value) {
        if (value.isNull()) {
            return;
        }
        FieldDefImpl def = (FieldDefImpl)this.getVariableType(varName);
        if (def == null) {
            throw new IllegalArgumentException("Variable " + varName + " has not been declared in the query");
        }
        if (!((FieldDefImpl)value.getDefinition()).isSubtype(def)) {
            throw new IllegalArgumentException("Variable " + varName + " does not have an expected type. Expected " + def.getType() + " or subtype, got " + value.getType());
        }
        this.checkRecordsContainAllFields(varName, value);
    }

    private void checkRecordsContainAllFields(String varName, FieldValue value) {
        block6: {
            FieldDef def;
            block7: {
                block5: {
                    if (value.isNull()) {
                        return;
                    }
                    def = value.getDefinition();
                    if (!def.isRecord()) break block5;
                    RecordValueImpl rec = (RecordValueImpl)value.asRecord();
                    for (int i = 0; i < rec.getNumFields(); ++i) {
                        FieldValueImpl fval = rec.get(i);
                        if (fval == null) {
                            String fname = rec.getFieldName(i);
                            throw new IllegalArgumentException("Value for variable " + varName + " not conforming to type definition: there is no value for field: '" + fname + "'.");
                        }
                        this.checkRecordsContainAllFields(varName, fval);
                    }
                    break block6;
                }
                if (!def.isArray()) break block7;
                for (FieldValue v : value.asArray().toList()) {
                    this.checkRecordsContainAllFields(varName, v);
                }
                break block6;
            }
            if (!def.isMap()) break block6;
            for (FieldValue v : ((MapValueImpl)value.asMap()).getFieldsInternal().values()) {
                this.checkRecordsContainAllFields(varName, v);
            }
        }
    }

    @Override
    public StatementResult executeSync(KVStoreImpl store, ExecuteOptions options) {
        if (options == null) {
            options = new ExecuteOptions();
        }
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, false);
    }

    @Override
    public AsyncIterationHandleImpl<RecordValue> executeAsync(KVStoreImpl store, ExecuteOptions options) {
        if (options == null) {
            options = new ExecuteOptions();
        }
        QueryStatementResultImpl result = new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, true);
        return result.getExecutionHandle();
    }
}

