/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.map;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.kv.Key;
import oracle.kv.impl.map.KeyToPartitionMap;
import oracle.kv.impl.topo.PartitionId;

public class HashKeyToPartitionMap
implements KeyToPartitionMap {
    private static final long serialVersionUID = 1L;
    final BigInteger nPartitions;
    transient DigestCache digestCache = new DigestCache();

    public HashKeyToPartitionMap(int nPartitions) {
        this.nPartitions = new BigInteger(Integer.toString(nPartitions));
    }

    @Override
    public int getNPartitions() {
        return this.nPartitions.intValue();
    }

    @Override
    public PartitionId getPartitionId(byte[] keyBytes) {
        if (this.digestCache == null) {
            this.digestCache = new DigestCache();
        }
        MessageDigest md = this.digestCache.get();
        md.update(keyBytes, 0, Key.getMajorPathLength(keyBytes));
        BigInteger index = new BigInteger(md.digest()).mod(this.nPartitions);
        return new PartitionId(index.intValue() + 1);
    }

    static class DigestCache
    extends ThreadLocal<MessageDigest> {
        DigestCache() {
        }

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MD5 algorithm unavailable");
            }
        }

        @Override
        public MessageDigest get() {
            MessageDigest md = (MessageDigest)super.get();
            md.reset();
            return md;
        }
    }
}

