/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldValue;

public class ExprInsertRow
extends Expr {
    public static RecordDefImpl theNumRowsInsertedType;
    private TableImpl theTable;
    private ArrayList<Integer> theColPositions;
    private ArrayList<Expr> theArgs;
    private Expr.UpdateKind theTTLKind;
    private boolean theIsUpsert;
    private boolean theHasReturningClause;
    private RowImpl theRow;

    ExprInsertRow(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, TableImpl table, ArrayList<Integer> colPositions, boolean isUpsert, boolean hasReturningClause) {
        super(qcb, sctx, Expr.ExprKind.INSERT_ROW, location);
        this.theTable = table;
        this.theColPositions = colPositions;
        this.theRow = table.createRow();
        this.theArgs = new ArrayList(this.theRow.getNumFields());
        this.theIsUpsert = isUpsert;
        this.theHasReturningClause = hasReturningClause;
        this.theType = hasReturningClause ? TypeManager.createTableRecordType(table, ExprType.Quantifier.QSTN) : TypeManager.createType(theNumRowsInsertedType, ExprType.Quantifier.ONE);
    }

    void addInsertClause(Expr arg, QueryException.Location loc) {
        FieldValueImpl val = null;
        if (this.theArgs.size() >= this.theRow.getNumFields()) {
            throw new QueryException("Insert statements contains more VALUES expressions than the number of table columns", loc);
        }
        if (this.theColPositions != null && this.theArgs.size() >= this.theColPositions.size()) {
            throw new QueryException("Insert statements contains more VALUES expressions than the number of specified columns", loc);
        }
        int fpos = this.theColPositions == null ? this.theArgs.size() + this.theRow.size() : this.theColPositions.get(this.theArgs.size());
        FieldDefImpl ftype = this.theRow.getFieldDef(fpos);
        if (arg != null && this.theTable.hasIdentityColumn() && this.theTable.getIdentityColumn() == fpos && this.theTable.isIdentityGeneratedAlways()) {
            throw new QueryException("Generated always identity column must use DEFAULT construct.", loc);
        }
        if (arg == null) {
            if (this.theTable.hasIdentityColumn() && this.theTable.getIdentityColumn() == fpos) {
                this.theRow.putInternal(fpos, (FieldValue)EmptyValueImpl.getInstance(), false);
                return;
            }
            if (this.theTable.isPrimKeyAtPos(fpos)) {
                throw new QueryException("There is no default value for primary-key column " + this.theRow.getFieldName(fpos), loc);
            }
            val = this.theRow.getDefinition().getDefaultValue(fpos);
            this.putValue(fpos, val);
            if (this.theColPositions != null) {
                this.theColPositions.remove(this.theArgs.size());
            }
            return;
        }
        if (arg.getKind() == Expr.ExprKind.CONST) {
            val = ((ExprConst)arg).getValue();
            if ((val.isNull() || val.isJsonNull()) && this.theTable.hasIdentityColumn() && this.theTable.getIdentityColumn() == fpos && this.theTable.isIdentityOnNull()) {
                this.theRow.putInternal(fpos, (FieldValue)NullValueImpl.getInstance(), false);
                if (this.theColPositions != null) {
                    this.theColPositions.remove(this.theArgs.size());
                }
                return;
            }
            if (val.isJsonNull() || val.getDefinition().equals(ftype)) {
                this.putValue(fpos, val);
                if (this.theColPositions != null) {
                    this.theColPositions.remove(this.theArgs.size());
                }
                return;
            }
        }
        if ((arg = ExprCast.create(this.theQCB, this.theSctx, arg.getLocation(), arg, ftype, ExprType.Quantifier.QSTN)).getKind() == Expr.ExprKind.CONST) {
            val = ((ExprConst)arg).getValue();
        } else if (Expr.ConstKind.isCompileConst(arg)) {
            List<FieldValueImpl> vals = ExprUtils.computeConstExpr(arg);
            if (vals.size() > 1) {
                throw new QueryException("A VALUES expression returns more than one items", loc);
            }
            FieldValueImpl fieldValueImpl = val = vals.size() == 1 ? vals.get(0) : NullValueImpl.getInstance();
        }
        if (val != null) {
            this.putValue(fpos, val);
            if (this.theColPositions != null) {
                this.theColPositions.remove(this.theArgs.size());
            }
        } else {
            this.theArgs.add(arg);
            arg.addParent(this);
        }
    }

    private void putValue(int fpos, FieldValueImpl val) {
        if (val.isNull()) {
            this.theRow.putNull(fpos);
        } else if (val.isJsonNull()) {
            FieldDefImpl ftype = this.theRow.getFieldDef(fpos);
            if (ftype.equals(FieldDefImpl.jsonDef)) {
                this.theRow.put(fpos, (FieldValue)val);
            } else {
                this.theRow.putNull(fpos);
            }
        } else {
            this.theRow.put(fpos, (FieldValue)val);
        }
    }

    void addTTLClause(Expr ttlExpr, Expr.UpdateKind ttlKind) {
        if (ttlExpr != null) {
            this.theArgs.add(ttlExpr);
            ttlExpr.addParent(this);
        }
        this.theTTLKind = ttlKind;
    }

    void validate() {
        int i;
        boolean haveTTLExpr;
        int numCols = this.theRow.getNumFields();
        boolean bl = haveTTLExpr = this.theTTLKind == Expr.UpdateKind.TTL_HOURS || this.theTTLKind == Expr.UpdateKind.TTL_DAYS;
        if (this.theColPositions == null) {
            int numValues = this.theRow.size() + this.theArgs.size() - (haveTTLExpr ? 1 : 0);
            if (numValues != numCols) {
                throw new QueryException("The number of VALUES expressions is not equal to the number of table columns", this.theLocation);
            }
            this.theColPositions = new ArrayList(numCols);
            for (int i2 = 0; i2 < numCols; ++i2) {
                if (this.theRow.get(i2) != null) continue;
                this.theColPositions.add(i2);
            }
            return;
        }
        if (this.theColPositions.size() != this.theArgs.size() - (haveTTLExpr ? 1 : 0)) {
            throw new QueryException("The number of VALUES expressions is not equal to the number of specified table columns", this.theLocation);
        }
        int[] pkPositions = this.theTable.getPrimKeyPositions();
        for (i = 0; i < pkPositions.length; ++i) {
            boolean pkIsIdentity;
            int j;
            if (this.theRow.get(pkPositions[i]) != null) continue;
            for (j = 0; j < this.theColPositions.size() && this.theColPositions.get(j) != pkPositions[i]; ++j) {
            }
            boolean bl2 = pkIsIdentity = this.theTable.hasIdentityColumn() && this.theTable.getIdentityColumn() == pkPositions[i];
            if (j != this.theColPositions.size() || pkIsIdentity) continue;
            throw new QueryException("No value specified for primary key column " + this.theRow.getFieldName(pkPositions[i]), this.theLocation);
        }
        for (i = 0; i < numCols; ++i) {
            if (this.theRow.get(i) != null || this.theTable.isPrimKeyAtPos(i) || this.theTable.hasIdentityColumn() && this.theTable.getIdentityColumn() == i) continue;
            FieldValueImpl fv = this.theRow.getDefinition().getDefaultValue(i);
            this.theRow.putInternal(i, (FieldValue)fv, false);
        }
    }

    TableImpl getTable() {
        return this.theTable;
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    RowImpl getRow() {
        return this.theRow;
    }

    ArrayList<Integer> getColPositions() {
        return this.theColPositions;
    }

    boolean isUpsert() {
        return this.theIsUpsert;
    }

    boolean updateTTL() {
        return this.theTTLKind != null;
    }

    Expr.UpdateKind getTTLKind() {
        return this.theTTLKind;
    }

    Expr getTTLExpr() {
        if (this.theTTLKind == Expr.UpdateKind.TTL_HOURS || this.theTTLKind == Expr.UpdateKind.TTL_DAYS) {
            return this.theArgs.get(this.theArgs.size() - 1);
        }
        return null;
    }

    boolean hasReturningClause() {
        return this.theHasReturningClause;
    }

    @Override
    ExprType computeType() {
        return this.theType;
    }

    @Override
    boolean mayReturnNULL() {
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 1; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n");
        this.theArgs.get(0).display(sb, formatter);
    }

    static {
        FieldMap fmap = new FieldMap();
        fmap.put("NumRowsInserted", FieldDefImpl.integerDef, false, FieldDefImpl.integerDef.createInteger(1));
        theNumRowsInsertedType = FieldDefFactory.createRecordDef(fmap, null);
    }
}

