/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.impl.util.sklogger.Metric;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.StatsData;

public class LongGauge
extends Metric<Element> {
    public LongGauge(String name, String ... labelNames) {
        super(name, labelNames);
        this.initializeNoLabelsElement();
    }

    @Override
    protected Element newElement() {
        return new Element();
    }

    public void setValue(long newValue) {
        ((Element)this.noLabelsElement).setValue(newValue);
    }

    public long getValue() {
        return ((Element)this.noLabelsElement).getValue();
    }

    public void incrValue() {
        ((Element)this.noLabelsElement).incrValue();
    }

    public void incrValue(long delta) {
        ((Element)this.noLabelsElement).incrValue(delta);
    }

    public void decrValue() {
        ((Element)this.noLabelsElement).decrValue();
    }

    public void decrValue(long delta) {
        ((Element)this.noLabelsElement).decrValue(delta);
    }

    @Override
    public MetricFamilySamples<GaugeResult> collect() {
        ArrayList samples = new ArrayList(this.elements.size());
        for (Map.Entry e : this.elements.entrySet()) {
            samples.add(new MetricFamilySamples.Sample<GaugeResult>(Arrays.asList((String[])e.getKey()), new GaugeResult(((Element)e.getValue()).getValue())));
        }
        return new MetricFamilySamples<GaugeResult>(this.statsName, StatsData.Type.LONG_GAUGE, this.labelNames, samples);
    }

    public static class GaugeResult
    extends Metric.Result {
        private static final long serialVersionUID = 1L;
        private long gaugeVal;

        public GaugeResult(long gaugeVal) {
            this.gaugeVal = gaugeVal;
        }

        public long getGaugeVal() {
            return this.gaugeVal;
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", this.gaugeVal);
            return map;
        }
    }

    public static final class Element
    implements Metric.Element {
        private final AtomicLong value = new AtomicLong(0L);

        private Element() {
        }

        public long getValue() {
            return this.value.get();
        }

        public void incrValue() {
            this.value.incrementAndGet();
        }

        public void incrValue(long delta) {
            this.value.addAndGet(delta);
        }

        public void decrValue() {
            this.value.decrementAndGet();
        }

        public void decrValue(long delta) {
            this.value.addAndGet(-delta);
        }

        public void setValue(long newValue) {
            this.value.set(newValue);
        }
    }
}

