/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.oracle;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.oracle.SessionExchanger;

public final class ProxyAuthenticationUsersAndProperties {
    public static final String PA_CONNECTION_USER = "pa.connection.user";
    public static String connectionUserDefault = "PA_CONN";
    public static final String PA_CONNECTION_PASSWORD = "pa.connection.password";
    public static String connectionPasswordDefault = "PA_CONN";
    public static final String PA_PROXYUSER = "pa.proxyuser";
    public static String proxyUserDefault = "PA_PROXY";
    public static final String PA_PROXYUSERPWD = "pa.proxyuser.password";
    public static String proxyUserPasswordDefault = "PA_PROXY";
    public static final String PA_PROXYUSER2 = "pa.proxyuser2";
    public static String proxyUser2Default = "PA_PROXY2";
    public static final String PA_PROXYUSER2PWD = "pa.proxyuser2.password";
    public static String proxyUser2PasswordDefault = "PA_PROXY2";
    public static String connectionUser;
    public static String connectionPassword;
    public static String proxyUser;
    public static String proxyUserPassword;
    public static String proxyUser2;
    public static String proxyUser2Password;
    public static Properties connectionProperties;
    public static Map<String, Object> proxyProperties;
    public static Map<String, Object> proxyProperties2;
    public static Map<String, Object> cancelProxyProperties;

    public static String getProperty(String property, String defaultValue) {
        String propertyValue = System.getProperty(property);
        if (propertyValue == null || propertyValue.equals("")) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static void initialize() {
        connectionUser = ProxyAuthenticationUsersAndProperties.getProperty(PA_CONNECTION_USER, connectionUserDefault);
        connectionPassword = ProxyAuthenticationUsersAndProperties.getProperty(PA_CONNECTION_PASSWORD, connectionPasswordDefault);
        connectionProperties = new Properties();
        connectionProperties.setProperty("user", connectionUser);
        connectionProperties.setProperty("password", connectionPassword);
        proxyUser = ProxyAuthenticationUsersAndProperties.getProperty(PA_PROXYUSER, proxyUserDefault);
        proxyUserPassword = ProxyAuthenticationUsersAndProperties.getProperty(PA_PROXYUSERPWD, proxyUserPasswordDefault);
        proxyProperties = new HashMap<String, Object>(3);
        proxyProperties.put("eclipselink.oracle.proxy-type", 1);
        proxyProperties.put("PROXY_USER_NAME", proxyUser);
        proxyProperties.put("PROXY_USER_PASSWORD", proxyUserPassword);
        proxyUser2 = ProxyAuthenticationUsersAndProperties.getProperty(PA_PROXYUSER2, proxyUser2Default);
        proxyUser2Password = ProxyAuthenticationUsersAndProperties.getProperty(PA_PROXYUSER2PWD, proxyUser2PasswordDefault);
        proxyProperties2 = new HashMap<String, Object>(3);
        proxyProperties2.put("eclipselink.oracle.proxy-type", 1);
        proxyProperties2.put("PROXY_USER_NAME", proxyUser2);
        proxyProperties2.put("PROXY_USER_PASSWORD", proxyUser2Password);
        cancelProxyProperties = new HashMap<String, Object>(1);
        cancelProxyProperties.put("eclipselink.oracle.proxy-type", "");
    }

    public static String verify(DatabaseSession dbSession) {
        Object errorMsg = "";
        SessionExchanger exchanger = new SessionExchanger();
        DatabaseSession newSession = null;
        try {
            newSession = exchanger.createNewSession(dbSession, true, false, connectionProperties, null);
        }
        catch (Exception exception) {
            errorMsg = ProxyAuthenticationUsersAndProperties.createErrorMsgConnectionFailed();
            errorMsg = (String)errorMsg + ProxyAuthenticationUsersAndProperties.createErrorMsgProxyFailed(true);
            errorMsg = (String)errorMsg + ProxyAuthenticationUsersAndProperties.createErrorMsgProxy2Failed(true);
        }
        if (((String)errorMsg).length() == 0) {
            OracleConnection oracleConnection;
            Properties props;
            try {
                props = new Properties();
                props.setProperty("PROXY_USER_NAME", proxyUser);
                props.setProperty("PROXY_USER_PASSWORD", proxyUserPassword);
                oracleConnection = (OracleConnection)((AbstractSession)newSession).getAccessor().getConnection();
                oracleConnection.openProxySession(1, props);
                oracleConnection.close(1);
            }
            catch (Exception exception) {
                errorMsg = (String)errorMsg + ProxyAuthenticationUsersAndProperties.createErrorMsgProxyFailed(false);
            }
            try {
                props = new Properties();
                props.setProperty("PROXY_USER_NAME", proxyUser2);
                props.setProperty("PROXY_USER_PASSWORD", proxyUser2Password);
                oracleConnection = (OracleConnection)((AbstractSession)newSession).getAccessor().getConnection();
                oracleConnection.openProxySession(1, props);
                oracleConnection.close(1);
            }
            catch (Exception exception) {
                errorMsg = (String)errorMsg + ProxyAuthenticationUsersAndProperties.createErrorMsgProxy2Failed(false);
            }
        }
        exchanger.returnOriginalSession();
        return errorMsg;
    }

    static String createErrorMsgConnectionFailed() {
        String str1 = "Failed to connect using user = " + connectionUser + "; password = " + connectionPassword + ".\n";
        String str2 = "Specify connectionUser in pa.connection.user and connectionPassword in pa.connection.password System properties.\n";
        String str3 = "Otherwise default connectionUser " + connectionUserDefault + " and default connectionPassword " + connectionPasswordDefault + " used.\n";
        String str4 = "In the db connectionUser should exist (authenticated by connectionPassword) and be authorized to connect:\n";
        String str5 = " create user " + connectionUser + " identified by " + connectionPassword + "\n";
        String str6 = " grant connect to " + connectionUser + "\n";
        return str1 + str2 + str3 + str4 + str5 + str6;
    }

    static String createErrorMsgProxyFailed(boolean connectionHasFailed) {
        Object str1 = "";
        if (!connectionHasFailed) {
            str1 = "Failed to open proxy session using proxyUser = " + proxyUser + " on connection through " + connectionUser + ".\n";
        }
        String str2 = "Specify proxyUser in pa.proxyuser System property. Otherwise default proxyUser " + proxyUserDefault + " is used.\n";
        String str3 = "In the db proxyUser should exist and be authorized to connect both directly and through connectionUser:\n";
        String str4 = " create user " + proxyUser + " identified by " + proxyUser + "\n";
        String str5 = " grant connect to " + proxyUser + "\n";
        String str6 = " grant connect to " + proxyUser + " through " + connectionUser + "\n";
        return (String)str1 + str2 + str3 + str4 + str5 + str6;
    }

    static String createErrorMsgProxy2Failed(boolean connectionHasFailed) {
        Object str1 = "";
        if (!connectionHasFailed) {
            str1 = "Failed to open proxy session using proxyUser2 = " + proxyUser2 + " on connection through " + connectionUser + ".\n";
        }
        String str2 = "Specify proxyUser2 in pa.proxyuser System property. Otherwise default proxyUser2 " + proxyUser2Default + " is used.\n";
        String str3 = "In the db proxyUser2 should exist and be authorized to connect both directly and through connectionUser:\n";
        String str4 = " create user " + proxyUser2 + " identified by " + proxyUser2 + "\n";
        String str5 = " grant connect to " + proxyUser2 + "\n";
        String str6 = " grant connect to " + proxyUser2 + " through " + connectionUser + "\n";
        return (String)str1 + str2 + str3 + str4 + str5 + str6;
    }
}

