/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.databinding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class Snippet001NestedSelectionWithCombo
extends Group {
    private final ViewModel viewModel = new ViewModel();

    public Snippet001NestedSelectionWithCombo(Composite parent, int style) {
        super(parent, style);
        this.createPartControl();
    }

    public void createPartControl() {
        Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.setLayout((Layout)formLayout);
        this.setText("Nested Selection Snippet 001 - Binding Example");
        Label info1 = new Label((Composite)this, 0);
        info1.setText("This snippet demonstrates the databinding using a Lists and Combos");
        FormData data = new FormData(-1, -1);
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        info1.setLayoutData((Object)data);
        Label info2 = new Label((Composite)this, 0);
        info2.setText("Modifications in the TextBox and the Combobox will update the model (for the selection in the list).");
        data = new FormData(-1, -1);
        data.top = new FormAttachment((Control)info1, 5);
        data.left = new FormAttachment(0, 0);
        info2.setLayoutData((Object)data);
        List peopleList = new List((Composite)this, 2048);
        data = new FormData(95, -1);
        data.top = new FormAttachment((Control)info2, 5);
        data.left = new FormAttachment(0, 0);
        peopleList.setLayoutData((Object)data);
        ListViewer peopleListViewer = new ListViewer(peopleList);
        IObservableSet staticObservableSet = Observables.staticObservableSet((Realm)realm, new HashSet(this.viewModel.getPeople()));
        IObservableMap attributeMap = BeanProperties.value(Person.class, (String)"name", String.class).observeDetail(staticObservableSet);
        ObservableMapLabelProvider omlProvider = new ObservableMapLabelProvider(attributeMap);
        peopleListViewer.setLabelProvider((IBaseLabelProvider)omlProvider);
        peopleListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        peopleListViewer.setInput((Object)this.viewModel.getPeople());
        Text name = new Text((Composite)this, 2048);
        data = new FormData(95, -1);
        data.top = new FormAttachment((Control)peopleList, 5);
        data.left = new FormAttachment(0, 0);
        name.setLayoutData((Object)data);
        Combo city = new Combo((Composite)this, 2056);
        data = new FormData(95, -1);
        data.top = new FormAttachment((Control)name, 5);
        data.left = new FormAttachment(0, 0);
        city.setLayoutData((Object)data);
        DataBindingContext dbc = new DataBindingContext(realm);
        IViewerObservableValue selectedPerson = ViewersObservables.observeSingleSelection((Viewer)peopleListViewer);
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)name, (int)24), BeanProperties.value(Person.class, (String)"name", String.class).observeDetail((IObservableValue)selectedPerson));
        ComboViewer cityViewer = new ComboViewer(city);
        cityViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        cityViewer.setInput((Object)this.viewModel.getCities());
        IViewerObservableValue citySelection = ViewersObservables.observeSingleSelection((Viewer)cityViewer);
        dbc.bindValue((IObservableValue)citySelection, BeanProperties.value(Person.class, (String)"city", String.class).observeDetail((IObservableValue)selectedPerson));
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener lsnr) {
            this.propertyChangeSupport.addPropertyChangeListener(lsnr);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, lsnr);
        }

        public void removePropertyChangeListener(PropertyChangeListener lsnr) {
            this.propertyChangeSupport.removePropertyChangeListener(lsnr);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, lsnr);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class Person
    extends AbstractModelObject {
        String name;
        String city;

        public Person(String name, String city) {
            this.name = name;
            this.city = city;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            String oldValue = this.city;
            this.city = city;
            this.firePropertyChange("city", oldValue, city);
        }
    }

    static class ViewModel
    extends AbstractModelObject {
        private final ArrayList people = new ArrayList();
        private final ArrayList cities;

        ViewModel() {
            this.people.add(new Person("Wile E. Coyote", "Tucson"));
            this.people.add(new Person("Road Runner", "Lost Horse"));
            this.people.add(new Person("Bugs Bunny", "Forrest"));
            this.cities = new ArrayList();
            this.cities.add("Tucson");
            this.cities.add("AcmeTown");
            this.cities.add("Lost Horse");
            this.cities.add("Forrest");
            this.cities.add("Lost Mine");
        }

        public ArrayList getPeople() {
            return this.people;
        }

        public ArrayList getCities() {
            return this.cities;
        }
    }
}

