/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.api.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDebugView
extends ViewPart
implements ISelectionListener {
    private Text info;
    private List<Action> actions = new ArrayList<Action>();
    private Combo actionSelector;
    private Object selection;

    public Object getSelection() {
        return this.selection;
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.info = new Text(parent, 2890);
        this.info.setText("Sirius Debug View");
        this.info.setLayoutData((Object)new GridData(1808));
        this.info.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        Group buttons = new Group(parent, 16);
        buttons.setLayoutData((Object)new GridData(768));
        buttons.setLayout((Layout)new RowLayout(256));
        this.actionSelector = new Combo((Composite)buttons, 12);
        Button actionLauncher = new Button((Composite)buttons, 8);
        actionLauncher.setText("Run");
        actionLauncher.addSelectionListener(SelectionListener.widgetSelectedAdapter(evt -> {
            int idx = this.actionSelector.getSelectionIndex();
            if (idx != -1) {
                this.actions.get((int)idx).body.run();
            }
        }));
        this.createActionButtons();
    }

    protected void addAction(String name, Runnable body) {
        Action action = new Action(name, body);
        this.actions.add(action);
        this.actionSelector.add(action.label);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
        Optional<Object> selected = this.getSelectedElement(newSelection);
        if (selected.isPresent()) {
            this.selection = selected.get();
            this.info.setText(this.getTextFor(this.selection));
        }
    }

    private Optional<Object> getSelectedElement(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)newSelection;
            return Optional.ofNullable(structuredSelection.getFirstElement());
        }
        return Optional.empty();
    }

    protected String askStringFromUser(String title, String message, String initialValue) {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), title, message, initialValue, null);
        if (dlg.open() == 0) {
            return dlg.getValue();
        }
        return null;
    }

    protected AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    public void setText(String text) {
        this.info.setText(text);
    }

    protected abstract String getTextFor(Object var1);

    protected abstract void createActionButtons();

    private static class Action {
        final String label;
        final Runnable body;

        Action(String label, Runnable body) {
            this.label = label;
            this.body = body;
        }
    }
}

