/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.internal.validation.description.constraints.AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;

public class EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint
extends AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint {
    public IStatus validate(IValidationContext ctx) {
        IStatus status = null;
        EObject target = ctx.getTarget();
        if (target instanceof EAttributeCustomization) {
            EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)target;
            status = this.validateEAttributeCustomization(eAttributeCustomization, ctx);
        }
        if (status == null) {
            status = ctx.createSuccessStatus();
        }
        return status;
    }

    private IStatus validateEAttributeCustomization(EAttributeCustomization eAttributeCustomization, IValidationContext ctx) {
        IStatus status = null;
        String attributeName = eAttributeCustomization.getAttributeName();
        Iterator appliedOnIterator = eAttributeCustomization.getAppliedOn().iterator();
        if (appliedOnIterator.hasNext()) {
            EObject firstStyleDescriptionElt = (EObject)appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(firstStyleDescriptionElt)) {
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_validationStyleDescriptionErrorMsg, this.getPath(firstStyleDescriptionElt))});
            } else {
                EStructuralFeature eStructuralFeature = firstStyleDescriptionElt.eClass().getEStructuralFeature(attributeName);
                if (eStructuralFeature instanceof EAttribute) {
                    EClassifier firstEType = eStructuralFeature.getEType();
                    status = this.validateFollowingStyleDescriptionElts(appliedOnIterator, firstStyleDescriptionElt, firstEType, attributeName, ctx);
                } else {
                    status = eStructuralFeature == null ? ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_validationNotExistErrorMsg, attributeName, this.getPath(firstStyleDescriptionElt))}) : ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_notEAttributeErrorMsg, attributeName, this.getPath(firstStyleDescriptionElt), eStructuralFeature)});
                }
            }
        }
        return status;
    }

    private IStatus validateFollowingStyleDescriptionElts(Iterator<EObject> appliedOnIterator, EObject firstStyleDescriptionElt, EClassifier firstEType, String attributeName, IValidationContext ctx) {
        IStatus status = null;
        while (appliedOnIterator.hasNext()) {
            EObject next = appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(next)) {
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_validationStyleDescriptionErrorMsg, this.getPath(next))});
                break;
            }
            EStructuralFeature eStructuralFeature = next.eClass().getEStructuralFeature(attributeName);
            if (eStructuralFeature instanceof EAttribute) {
                if (firstEType == eStructuralFeature.getEType()) continue;
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_EAttributeDiffernentTypesErrorMsg, this.getPath(firstStyleDescriptionElt), this.getPath(next), attributeName)});
                break;
            }
            if (eStructuralFeature == null) {
                status = ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_validationNotExistErrorMsg, attributeName, this.getPath(next))});
                continue;
            }
            status = ctx.createFailureStatus(new Object[]{MessageFormat.format(Messages.EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint_notEAttributeErrorMsg, attributeName, this.getPath(next), eStructuralFeature)});
            break;
        }
        return status;
    }
}

