/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemRegistry;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyTabItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertyTabSorter;

public class LegacyPropertyTabRegistry
implements IItemRegistry {
    private Map<String, List<IItemDescriptor>> id2descriptors = new HashMap<String, List<IItemDescriptor>>();

    public List<IEEFTabDescriptor> getPropertyTabs(String contributorId) {
        List<IEEFTabDescriptor> tabs = this.readTabDescriptors(contributorId);
        List<String> propertyCategories = this.readPropertyCategories();
        List<IEEFTabDescriptor> sortedTabs = this.sortTabDescriptorsByCategory(tabs, propertyCategories);
        sortedTabs = this.sortTabDescriptorsByAfterTab(sortedTabs, propertyCategories);
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByCategory(List<IEEFTabDescriptor> tabs, final List<String> propertyCategories) {
        ArrayList<IEEFTabDescriptor> sortedTabs = new ArrayList<IEEFTabDescriptor>(tabs);
        if (propertyCategories != null) {
            Collections.sort(sortedTabs, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    IEEFTabDescriptor one = (IEEFTabDescriptor)arg0;
                    IEEFTabDescriptor two = (IEEFTabDescriptor)arg1;
                    String categoryOne = one.getCategory();
                    String categoryTwo = two.getCategory();
                    if (categoryOne != null && categoryTwo != null) {
                        int categoryOnePosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryOne);
                        int categoryTwoPosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryTwo);
                        return categoryOnePosition - categoryTwoPosition;
                    }
                    return 0;
                }
            });
        }
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByAfterTab(List<IEEFTabDescriptor> tabs, List<String> propertyCategories) {
        if (tabs.size() == 0 || propertyCategories == null) {
            return tabs;
        }
        ArrayList<IEEFTabDescriptor> sorted = new ArrayList<IEEFTabDescriptor>();
        int i = 0;
        while (i < propertyCategories.size()) {
            ArrayList<IEEFTabDescriptor> categoryList = new ArrayList<IEEFTabDescriptor>();
            String category = propertyCategories.get(i);
            for (IEEFTabDescriptor tab : tabs) {
                if (category == null || !category.equals(tab.getCategory())) continue;
                categoryList.add(tab);
            }
            List<IEEFTabDescriptor> sortedTabs = this.sortCategoryTabsByAfterTab(categoryList);
            int j = 0;
            while (j < sortedTabs.size()) {
                sorted.add(sortedTabs.get(j));
                ++j;
            }
            ++i;
        }
        return sorted;
    }

    private List<IEEFTabDescriptor> sortCategoryTabsByAfterTab(List<IEEFTabDescriptor> categoryList) {
        return new LegacyPropertyTabSorter().sortTabsByAfterTab(categoryList);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (target != null && array[i] != null && array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<String> readPropertyCategories() {
        return EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getPropertyCategories();
    }

    private List<IEEFTabDescriptor> readTabDescriptors(String contributorId) {
        ArrayList<IEEFTabDescriptor> eefTabDescriptors = new ArrayList<IEEFTabDescriptor>();
        Collection values = this.id2descriptors.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        for (IItemDescriptor itemDescriptor : values) {
            LegacyPropertyTabItemDescriptor eefTabDescriptor;
            String eefTabContributorId;
            if (!(itemDescriptor instanceof LegacyPropertyTabItemDescriptor) || (eefTabContributorId = (eefTabDescriptor = (LegacyPropertyTabItemDescriptor)itemDescriptor).getContributorId()) == null || !eefTabContributorId.equals(contributorId)) continue;
            eefTabDescriptors.add((IEEFTabDescriptor)eefTabDescriptor);
        }
        return eefTabDescriptors;
    }

    @Override
    public IItemDescriptor add(IItemDescriptor descriptor) {
        List descriptors = this.id2descriptors.getOrDefault(descriptor.getId(), new ArrayList());
        boolean result = descriptors.add(descriptor);
        this.id2descriptors.put(descriptor.getId(), descriptors);
        if (result) {
            return descriptor;
        }
        return null;
    }

    @Override
    public boolean remove(String id) {
        List descriptors = Optional.ofNullable(this.id2descriptors.remove(id)).orElseGet(ArrayList::new);
        return !descriptors.isEmpty();
    }

    @Override
    public void clear() {
        this.id2descriptors.clear();
    }

    public void dispose() {
        this.id2descriptors.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(LegacyPropertyTabItemDescriptor.class::isInstance).map(LegacyPropertyTabItemDescriptor.class::cast).forEach(LegacyPropertyTabItemDescriptor::dispose);
    }
}

