/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.migration.design;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.FanRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.DForestRouter;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.AbstractRepresentation;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.BasicLabelStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Bordered;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.BorderedRepresentation;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.BorderedStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Container;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.ContainerRepresentation;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.ContainerStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Diagram;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.EdgeRepresentation;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.EdgeStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Filter;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.FontFormat;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.GraphicalElement;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.LabelAlignment;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.LabelPosition;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.LabelStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Layer;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.Layout;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.MigrationmodelerFactory;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.NodeRepresentation;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.NodeStyle;
import org.eclipse.sirius.tests.sample.migration.migrationmodeler.RoutingStyle;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class Draw2dToSiriusModelTransformer {
    private DDiagramEditPart dDiagramEditPart;

    public Draw2dToSiriusModelTransformer(DDiagramEditPart dDiagramEditPart) {
        this.dDiagramEditPart = dDiagramEditPart;
    }

    public Diagram getMigrationModel() {
        Diagram migrationDiagram = MigrationmodelerFactory.eINSTANCE.createDiagram();
        DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)this.dDiagramEditPart.resolveDDiagram().get();
        migrationDiagram.setName(new DRepresentationQuery((DRepresentation)dSemanticDiagram).getRepresentationDescriptor().getName());
        org.eclipse.gmf.runtime.notation.Diagram diagramView = this.dDiagramEditPart.getDiagramView();
        Map editPartRegistry = this.dDiagramEditPart.getViewer().getEditPartRegistry();
        HashMap<org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node, org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node> semanticNodeToMigrationNodeMap = new HashMap<org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node, org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node>();
        HashMap<Container, Container> semanticContainerToMigrationContainerMap = new HashMap<Container, Container>();
        EList children = diagramView.getChildren();
        for (Object childObj : children) {
            ContainerRepresentation containerRepresentation;
            Container migrationContainer;
            Container semanticContainer;
            Object value = editPartRegistry.get(childObj);
            if (!(childObj instanceof Node) || !(value instanceof IDiagramElementEditPart)) continue;
            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)value;
            if (diagramElementEditPart instanceof IDiagramContainerEditPart) {
                IDiagramContainerEditPart diagramContainerEditPart = (IDiagramContainerEditPart)diagramElementEditPart;
                semanticContainer = (Container)diagramContainerEditPart.resolveTargetSemanticElement();
                migrationContainer = (Container)semanticContainerToMigrationContainerMap.get(semanticContainer);
                if (migrationContainer == null) {
                    migrationContainer = MigrationmodelerFactory.eINSTANCE.createContainer();
                    migrationDiagram.getContainers().add((Object)migrationContainer);
                    semanticContainerToMigrationContainerMap.put(semanticContainer, migrationContainer);
                }
                containerRepresentation = this.getMigrationContainerRepresentation(diagramContainerEditPart);
                migrationContainer.getContainerRepresentations().add((Object)containerRepresentation);
                continue;
            }
            if (diagramElementEditPart instanceof IDiagramListEditPart) {
                IDiagramListEditPart diagramListEditPart = (IDiagramListEditPart)diagramElementEditPart;
                semanticContainer = (Container)diagramElementEditPart.resolveTargetSemanticElement();
                migrationContainer = (Container)semanticContainerToMigrationContainerMap.get(semanticContainer);
                if (migrationContainer == null) {
                    migrationContainer = MigrationmodelerFactory.eINSTANCE.createContainer();
                    migrationDiagram.getContainers().add((Object)migrationContainer);
                    semanticContainerToMigrationContainerMap.put(semanticContainer, migrationContainer);
                }
                containerRepresentation = this.getMigrationContainerRepresentation(diagramListEditPart);
                migrationContainer.getContainerRepresentations().add((Object)containerRepresentation);
                continue;
            }
            if (!(diagramElementEditPart instanceof IDiagramNodeEditPart)) continue;
            IDiagramNodeEditPart diagramNodeEditPart = (IDiagramNodeEditPart)diagramElementEditPart;
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node semanticNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)diagramNodeEditPart.resolveTargetSemanticElement();
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node migrationNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)semanticNodeToMigrationNodeMap.get(semanticNode);
            if (migrationNode == null) {
                migrationNode = MigrationmodelerFactory.eINSTANCE.createNode();
                migrationDiagram.getNodes().add((Object)migrationNode);
                semanticNodeToMigrationNodeMap.put(semanticNode, migrationNode);
            }
            NodeRepresentation nodeRepresentation = this.getMigrationNodeRepresentation(diagramNodeEditPart);
            migrationNode.getNodeRepresentations().add((Object)nodeRepresentation);
        }
        EList edges = diagramView.getEdges();
        HashMap<org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge, org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge> semanticEdgeToMigrationEdgeMap = new HashMap<org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge, org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge>();
        for (Object obj : edges) {
            Object value = editPartRegistry.get(obj);
            if (!(obj instanceof Edge) || !(value instanceof AbstractDiagramEdgeEditPart)) continue;
            AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart = (AbstractDiagramEdgeEditPart)value;
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge semanticEdge = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge)abstractDiagramEdgeEditPart.resolveTargetSemanticElement();
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge migrationEdge = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge)semanticEdgeToMigrationEdgeMap.get(semanticEdge);
            if (migrationEdge == null) {
                migrationEdge = MigrationmodelerFactory.eINSTANCE.createEdge();
                migrationDiagram.getEdges().add((Object)migrationEdge);
                semanticEdgeToMigrationEdgeMap.put(semanticEdge, migrationEdge);
            }
            EdgeRepresentation migrationEdgeRepresentation = this.getMigrationEdgeRepresentation(abstractDiagramEdgeEditPart);
            migrationEdge.getEdgeRepresentations().add((Object)migrationEdgeRepresentation);
            EditPart sourceEditPart = abstractDiagramEdgeEditPart.getSource();
            if (sourceEditPart instanceof IDiagramContainerEditPart || sourceEditPart instanceof IDiagramListEditPart) {
                Container semanticContainer = (Container)((IDiagramElementEditPart)sourceEditPart).resolveTargetSemanticElement();
                Container migrationContainer = (Container)semanticContainerToMigrationContainerMap.get(semanticContainer);
                migrationEdge.setSource((GraphicalElement)migrationContainer);
            } else if (sourceEditPart instanceof IDiagramNodeEditPart) {
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node semanticNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)((IDiagramElementEditPart)sourceEditPart).resolveTargetSemanticElement();
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node migrationNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)semanticNodeToMigrationNodeMap.get(semanticNode);
                migrationEdge.setSource((GraphicalElement)migrationNode);
            }
            EditPart targetEditPart = abstractDiagramEdgeEditPart.getTarget();
            if (targetEditPart instanceof IDiagramContainerEditPart || targetEditPart instanceof IDiagramListEditPart) {
                Container semanticContainer = (Container)((IDiagramElementEditPart)targetEditPart).resolveTargetSemanticElement();
                Container migrationContainer = (Container)semanticContainerToMigrationContainerMap.get(semanticContainer);
                migrationEdge.setTarget((GraphicalElement)migrationContainer);
                continue;
            }
            if (!(targetEditPart instanceof IDiagramNodeEditPart)) continue;
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node semanticNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)((IDiagramElementEditPart)targetEditPart).resolveTargetSemanticElement();
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node migrationNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)semanticNodeToMigrationNodeMap.get(semanticNode);
            migrationEdge.setTarget((GraphicalElement)migrationNode);
        }
        this.setFilters(dSemanticDiagram, migrationDiagram);
        this.setLayers(dSemanticDiagram, migrationDiagram);
        TreeIterator it = migrationDiagram.eAllContents();
        while (it.hasNext()) {
            AbstractRepresentation element;
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof AbstractRepresentation) || this.isPresentInDiagram(element = (AbstractRepresentation)eObject, dSemanticDiagram)) continue;
            element.setDisplayed(false);
        }
        return migrationDiagram;
    }

    public void updateMigrationModel(Diagram migrationDiagram) {
        this.clearRepresentations(migrationDiagram);
        DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)this.dDiagramEditPart.resolveDDiagram().get();
        migrationDiagram.setName(new DRepresentationQuery((DRepresentation)dSemanticDiagram).getRepresentationDescriptor().getName());
        org.eclipse.gmf.runtime.notation.Diagram diagramView = this.dDiagramEditPart.getDiagramView();
        Map editPartRegistry = this.dDiagramEditPart.getViewer().getEditPartRegistry();
        EList children = diagramView.getChildren();
        for (Object childObj : children) {
            ContainerRepresentation containerRepresentation;
            Container container;
            Iterator<Object> value = editPartRegistry.get(childObj);
            if (!(childObj instanceof Node) || !(value instanceof IDiagramElementEditPart)) continue;
            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)value;
            if (diagramElementEditPart instanceof IDiagramContainerEditPart) {
                IDiagramContainerEditPart diagramContainerEditPart = (IDiagramContainerEditPart)diagramElementEditPart;
                container = (Container)diagramContainerEditPart.resolveTargetSemanticElement();
                containerRepresentation = this.getMigrationContainerRepresentation(diagramContainerEditPart);
                container.getContainerRepresentations().add((Object)containerRepresentation);
                continue;
            }
            if (diagramElementEditPart instanceof IDiagramListEditPart) {
                IDiagramListEditPart diagramListEditPart = (IDiagramListEditPart)diagramElementEditPart;
                container = (Container)diagramElementEditPart.resolveTargetSemanticElement();
                containerRepresentation = this.getMigrationContainerRepresentation(diagramListEditPart);
                container.getContainerRepresentations().add((Object)containerRepresentation);
                continue;
            }
            if (!(diagramElementEditPart instanceof IDiagramNodeEditPart)) continue;
            IDiagramNodeEditPart diagramNodeEditPart = (IDiagramNodeEditPart)diagramElementEditPart;
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node node = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)diagramNodeEditPart.resolveTargetSemanticElement();
            NodeRepresentation nodeRepresentation = this.getMigrationNodeRepresentation(diagramNodeEditPart);
            node.getNodeRepresentations().add((Object)nodeRepresentation);
        }
        EList edges = diagramView.getEdges();
        for (Object obj : edges) {
            Object value = editPartRegistry.get(obj);
            if (!(obj instanceof Edge) || !(value instanceof AbstractDiagramEdgeEditPart)) continue;
            AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart = (AbstractDiagramEdgeEditPart)value;
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge edge = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge)abstractDiagramEdgeEditPart.resolveTargetSemanticElement();
            EdgeRepresentation migrationEdgeRepresentation = this.getMigrationEdgeRepresentation(abstractDiagramEdgeEditPart);
            edge.getEdgeRepresentations().add((Object)migrationEdgeRepresentation);
        }
        this.setFilters(dSemanticDiagram, migrationDiagram);
        this.setLayers(dSemanticDiagram, migrationDiagram);
        TreeIterator it = migrationDiagram.eAllContents();
        while (it.hasNext()) {
            AbstractRepresentation element;
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof AbstractRepresentation) || this.isPresentInDiagram(element = (AbstractRepresentation)eObject, dSemanticDiagram)) continue;
            element.setDisplayed(false);
        }
    }

    private void clearRepresentations(Diagram migrationDiagram) {
        for (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node node : migrationDiagram.getNodes()) {
            node.getNodeRepresentations().clear();
        }
        for (Container container : migrationDiagram.getContainers()) {
            container.getContainerRepresentations().clear();
            this.clearContainerElementRepresentations(container);
        }
        for (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Edge edge : migrationDiagram.getEdges()) {
            edge.getEdgeRepresentations().clear();
        }
    }

    private void clearContainerElementRepresentations(Container container) {
        for (GraphicalElement graphicalElement : container.getElements()) {
            if (graphicalElement instanceof org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node) {
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node node = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)graphicalElement;
                node.getNodeRepresentations().clear();
                continue;
            }
            if (graphicalElement instanceof Bordered) {
                Bordered bordered = (Bordered)graphicalElement;
                bordered.getBorderedRepresentations().clear();
                continue;
            }
            if (!(graphicalElement instanceof Container)) continue;
            Container subContainer = (Container)graphicalElement;
            subContainer.getContainerRepresentations().clear();
            this.clearContainerElementRepresentations(subContainer);
        }
    }

    private ContainerRepresentation getMigrationContainerRepresentation(IDiagramListEditPart diagramListEditPart) {
        Size size;
        Node node;
        ContainerRepresentation containerRepresentation = MigrationmodelerFactory.eINSTANCE.createContainerRepresentation();
        containerRepresentation.setMappingId(this.getMappingId((IDiagramElementEditPart)diagramListEditPart));
        ContainerStyle containerStyle = MigrationmodelerFactory.eINSTANCE.createContainerStyle();
        containerRepresentation.setOwnedStyle(containerStyle);
        this.updateLabelStyle((LabelStyle)containerStyle, (IDiagramElementEditPart)diagramListEditPart);
        this.updateBorderedStyle((BorderedStyle)containerStyle, (IDiagramElementEditPart)diagramListEditPart);
        Object model = diagramListEditPart.getModel();
        if (model instanceof Node && (node = (Node)model).getLayoutConstraint() instanceof Size && ((size = (Size)node.getLayoutConstraint()).getWidth() == -1 || size.getHeight() == -1)) {
            containerRepresentation.setAutoSized(true);
        }
        this.updateLayout((AbstractRepresentation)containerRepresentation, diagramListEditPart.getFigure());
        ArrayList children = new ArrayList(diagramListEditPart.getChildren());
        Iterator compart = diagramListEditPart.getChildren().stream().filter(ResizableCompartmentEditPart.class::isInstance).map(ResizableCompartmentEditPart.class::cast).iterator();
        if (compart.hasNext()) {
            ResizableCompartmentEditPart compartmentEditPart = (ResizableCompartmentEditPart)compart.next();
            children.addAll(compartmentEditPart.getChildren());
        }
        Iterable filter = () -> children.stream().filter(IAbstractDiagramNodeEditPart.class::isInstance).map(IAbstractDiagramNodeEditPart.class::cast).iterator();
        for (IAbstractDiagramNodeEditPart childEditPart : filter) {
            EObject targetSemanticElement = childEditPart.resolveTargetSemanticElement();
            if (targetSemanticElement instanceof org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node) {
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node subNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)targetSemanticElement;
                if (childEditPart instanceof IDiagramNodeEditPart) {
                    IDiagramNodeEditPart childNodeEditPart = (IDiagramNodeEditPart)childEditPart;
                    NodeRepresentation nodeRepresentation = this.getMigrationNodeRepresentation(childNodeEditPart);
                    subNode.getNodeRepresentations().add((Object)nodeRepresentation);
                    continue;
                }
            }
            if (targetSemanticElement instanceof Bordered) {
                Bordered subBordered = (Bordered)targetSemanticElement;
                BorderedRepresentation borderedRepresentation = this.getMigrationBorderedRepresentation(childEditPart);
                subBordered.getBorderedRepresentations().add((Object)borderedRepresentation);
                continue;
            }
            if (!(targetSemanticElement instanceof Container)) continue;
            Container subContainer = (Container)targetSemanticElement;
            ContainerRepresentation subContainerRepresentation = null;
            if (childEditPart instanceof IDiagramContainerEditPart) {
                subContainerRepresentation = this.getMigrationContainerRepresentation((IDiagramContainerEditPart)childEditPart);
            } else if (childEditPart instanceof IDiagramListEditPart) {
                subContainerRepresentation = this.getMigrationContainerRepresentation((IDiagramListEditPart)childEditPart);
            }
            if (subContainerRepresentation == null) continue;
            subContainer.getContainerRepresentations().add((Object)subContainerRepresentation);
        }
        return containerRepresentation;
    }

    private ContainerRepresentation getMigrationContainerRepresentation(IDiagramContainerEditPart diagramContainerEditPart) {
        Size size;
        Node node;
        ContainerRepresentation containerRepresentation = MigrationmodelerFactory.eINSTANCE.createContainerRepresentation();
        containerRepresentation.setMappingId(this.getMappingId((IDiagramElementEditPart)diagramContainerEditPart));
        ContainerStyle containerStyle = MigrationmodelerFactory.eINSTANCE.createContainerStyle();
        containerRepresentation.setOwnedStyle(containerStyle);
        this.updateLabelStyle((LabelStyle)containerStyle, (IDiagramElementEditPart)diagramContainerEditPart);
        this.updateBorderedStyle((BorderedStyle)containerStyle, (IDiagramElementEditPart)diagramContainerEditPart);
        Object model = diagramContainerEditPart.getModel();
        if (model instanceof Node && (node = (Node)model).getLayoutConstraint() instanceof Size && ((size = (Size)node.getLayoutConstraint()).getWidth() == -1 || size.getHeight() == -1)) {
            containerRepresentation.setAutoSized(true);
        }
        this.updateLayout((AbstractRepresentation)containerRepresentation, diagramContainerEditPart.getFigure());
        ArrayList children = new ArrayList(diagramContainerEditPart.getChildren());
        Optional<ResizableCompartmentEditPart> compart = diagramContainerEditPart.getChildren().stream().filter(ResizableCompartmentEditPart.class::isInstance).map(ResizableCompartmentEditPart.class::cast).findFirst();
        if (compart.isPresent()) {
            ResizableCompartmentEditPart compartmentEditPart = compart.get();
            children.addAll(compartmentEditPart.getChildren());
        }
        for (GraphicalEditPart child : children) {
            if (!(child instanceof IAbstractDiagramNodeEditPart)) continue;
            IAbstractDiagramNodeEditPart childEditPart = (IAbstractDiagramNodeEditPart)child;
            EObject targetSemanticElement = childEditPart.resolveTargetSemanticElement();
            if (targetSemanticElement instanceof org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node) {
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node subNode = (org.eclipse.sirius.tests.sample.migration.migrationmodeler.Node)targetSemanticElement;
                if (childEditPart instanceof IDiagramNodeEditPart) {
                    IDiagramNodeEditPart childNodeEditPart = (IDiagramNodeEditPart)childEditPart;
                    NodeRepresentation nodeRepresentation = this.getMigrationNodeRepresentation(childNodeEditPart);
                    subNode.getNodeRepresentations().add((Object)nodeRepresentation);
                    continue;
                }
            }
            if (targetSemanticElement instanceof Bordered) {
                Bordered subBordered = (Bordered)targetSemanticElement;
                BorderedRepresentation borderedRepresentation = this.getMigrationBorderedRepresentation(childEditPart);
                subBordered.getBorderedRepresentations().add((Object)borderedRepresentation);
                continue;
            }
            if (!(targetSemanticElement instanceof Container)) continue;
            Container subContainer = (Container)targetSemanticElement;
            ContainerRepresentation subContainerRepresentation = null;
            if (childEditPart instanceof IDiagramContainerEditPart) {
                IDiagramContainerEditPart subDiagramContainerEditPart = (IDiagramContainerEditPart)childEditPart;
                subContainerRepresentation = this.getMigrationContainerRepresentation(subDiagramContainerEditPart);
            } else if (childEditPart instanceof IDiagramListEditPart) {
                IDiagramListEditPart listEditPart = (IDiagramListEditPart)childEditPart;
                subContainerRepresentation = this.getMigrationContainerRepresentation(listEditPart);
            }
            if (subContainerRepresentation == null) continue;
            subContainer.getContainerRepresentations().add((Object)subContainerRepresentation);
        }
        return containerRepresentation;
    }

    private BorderedRepresentation getMigrationBorderedRepresentation(IAbstractDiagramNodeEditPart borderedEditPart) {
        BorderedRepresentation borderedRepresentation = MigrationmodelerFactory.eINSTANCE.createBorderedRepresentation();
        borderedRepresentation.setMappingId(this.getMappingId((IDiagramElementEditPart)borderedEditPart));
        NodeStyle nodeStyle = MigrationmodelerFactory.eINSTANCE.createNodeStyle();
        borderedRepresentation.setOwnedStyle(nodeStyle);
        this.updateNodeStyle(nodeStyle, (IDiagramElementEditPart)borderedEditPart);
        this.updateLayout((AbstractRepresentation)borderedRepresentation, borderedEditPart.getFigure());
        return borderedRepresentation;
    }

    private NodeRepresentation getMigrationNodeRepresentation(IDiagramNodeEditPart diagramNodeEditPart) {
        NodeRepresentation nodeRepresentation = MigrationmodelerFactory.eINSTANCE.createNodeRepresentation();
        nodeRepresentation.setMappingId(this.getMappingId((IDiagramElementEditPart)diagramNodeEditPart));
        IFigure figure = diagramNodeEditPart.getFigure();
        nodeRepresentation.setDisplayed(true);
        NodeStyle nodeStyle = MigrationmodelerFactory.eINSTANCE.createNodeStyle();
        nodeRepresentation.setOwnedStyle(nodeStyle);
        this.updateNodeStyle(nodeStyle, (IDiagramElementEditPart)diagramNodeEditPart);
        this.updateLayout((AbstractRepresentation)nodeRepresentation, figure);
        return nodeRepresentation;
    }

    private EdgeRepresentation getMigrationEdgeRepresentation(AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart) {
        DEdgeEndNameEditPart endDEdgeNameEditPart;
        DEdgeNameEditPart centerDEdgeNameEditPart;
        EdgeRepresentation edgeRepresentation = MigrationmodelerFactory.eINSTANCE.createEdgeRepresentation();
        edgeRepresentation.setMappingId(this.getMappingId((IDiagramElementEditPart)abstractDiagramEdgeEditPart));
        edgeRepresentation.setDisplayed(true);
        DEdge dEdge = (DEdge)abstractDiagramEdgeEditPart.resolveDiagramElement();
        Connection connectionFigure = abstractDiagramEdgeEditPart.getConnectionFigure();
        PointList points = abstractDiagramEdgeEditPart.getConnectionFigure().getPoints();
        if (points != null) {
            int i = 0;
            while (i < points.size()) {
                Point point = points.getPoint(i);
                org.eclipse.sirius.tests.sample.migration.migrationmodeler.Point migrationPoint = MigrationmodelerFactory.eINSTANCE.createPoint();
                migrationPoint.setX(point.x);
                migrationPoint.setY(point.y);
                edgeRepresentation.getBendpoints().add((Object)migrationPoint);
                ++i;
            }
        }
        EdgeStyle edgeStyle = MigrationmodelerFactory.eINSTANCE.createEdgeStyle();
        edgeRepresentation.setOwnedStyle(edgeStyle);
        RoutingStyle routingStyle = this.getRoutingStyle(connectionFigure);
        if (routingStyle != null) {
            edgeStyle.setRoutingStyle(routingStyle);
        }
        Color foregroundColor = connectionFigure.getForegroundColor();
        org.eclipse.sirius.tests.sample.migration.migrationmodeler.Color color = MigrationmodelerFactory.eINSTANCE.createColor();
        color.setRed(foregroundColor.getRed());
        color.setGreen(foregroundColor.getGreen());
        color.setBlue(foregroundColor.getBlue());
        edgeStyle.setColor(color);
        DEdgeBeginNameEditPart beginDEdgeNameEditPart = this.getDEdgeBeginNameEditPart(abstractDiagramEdgeEditPart);
        if (beginDEdgeNameEditPart != null && dEdge.getOwnedStyle().getBeginLabelStyle() != null) {
            BasicLabelStyle migrationBeginLabelStyle = this.getMigrationBasicLabelStyle((org.eclipse.sirius.viewpoint.BasicLabelStyle)dEdge.getOwnedStyle().getBeginLabelStyle(), (AbstractDEdgeNameEditPart)beginDEdgeNameEditPart);
            edgeStyle.setBeginLabelStyle(migrationBeginLabelStyle);
        }
        if ((centerDEdgeNameEditPart = this.getDEdgeCenterNameEditPart(abstractDiagramEdgeEditPart)) != null && dEdge.getOwnedStyle().getCenterLabelStyle() != null) {
            BasicLabelStyle migrationCenterLabelStyle = this.getMigrationBasicLabelStyle((org.eclipse.sirius.viewpoint.BasicLabelStyle)dEdge.getOwnedStyle().getCenterLabelStyle(), (AbstractDEdgeNameEditPart)centerDEdgeNameEditPart);
            edgeStyle.setCenterLabelStyle(migrationCenterLabelStyle);
        }
        if ((endDEdgeNameEditPart = this.getDEdgeEndNameEditPart(abstractDiagramEdgeEditPart)) != null && dEdge.getOwnedStyle().getEndLabelStyle() != null) {
            BasicLabelStyle migrationEndLabelStyle = this.getMigrationBasicLabelStyle((org.eclipse.sirius.viewpoint.BasicLabelStyle)dEdge.getOwnedStyle().getEndLabelStyle(), (AbstractDEdgeNameEditPart)endDEdgeNameEditPart);
            edgeStyle.setEndLabelStyle(migrationEndLabelStyle);
        }
        return edgeRepresentation;
    }

    private RoutingStyle getRoutingStyle(Connection connectionFigure) {
        RoutingStyle routingStyle = null;
        ConnectionRouter connectionRouter = connectionFigure.getConnectionRouter();
        if (connectionRouter instanceof RectilinearRouter) {
            routingStyle = RoutingStyle.MANHATTAN;
        } else if (connectionRouter instanceof FanRouter) {
            routingStyle = RoutingStyle.STRAIGHT;
        } else if (connectionRouter instanceof DForestRouter) {
            routingStyle = RoutingStyle.TREE;
        }
        return routingStyle;
    }

    private String getMappingId(IDiagramElementEditPart diagramListEditPart) {
        String mappingId = null;
        RepresentationElementMapping mapping = diagramListEditPart.resolveDiagramElement().getMapping();
        XMLResource xmlResource = (XMLResource)mapping.eResource();
        mappingId = xmlResource.getURIFragment((EObject)mapping);
        return mappingId;
    }

    private void updateNodeStyle(NodeStyle nodeStyle, IDiagramElementEditPart abstractGraphicalEditPart) {
        for (GraphicalEditPart child : abstractGraphicalEditPart.getChildren()) {
            if (!(child instanceof DNodeNameEditPart)) continue;
            DNodeNameEditPart dNodeNameEditPart = (DNodeNameEditPart)child;
            if (dNodeNameEditPart.getFigure().isVisible()) {
                nodeStyle.setLabelPosition(LabelPosition.BORDER);
                continue;
            }
            nodeStyle.setLabelPosition(LabelPosition.NODE);
        }
        this.updateLabelStyle((LabelStyle)nodeStyle, abstractGraphicalEditPart);
        this.updateBorderedStyle((BorderedStyle)nodeStyle, abstractGraphicalEditPart);
    }

    private void updateLabelStyle(LabelStyle labelStyle, IDiagramElementEditPart abstractGraphicalEditPart) {
        IFigure iFigure = abstractGraphicalEditPart.getFigure();
        if (iFigure instanceof SiriusWrapLabel) {
            SiriusWrapLabel viewpointWrapLabel = (SiriusWrapLabel)iFigure;
            LabelAlignment labelAlignment = null;
            switch (viewpointWrapLabel.getLabelAlignment2()) {
                case 2: {
                    labelAlignment = LabelAlignment.CENTER;
                    break;
                }
                case 1: {
                    labelAlignment = LabelAlignment.LEFT;
                    break;
                }
                case 4: {
                    labelAlignment = LabelAlignment.RIGHT;
                    break;
                }
                default: {
                    labelAlignment = LabelAlignment.CENTER;
                }
            }
            labelStyle.setLabelAlignment(labelAlignment);
        }
        TreeIterator iter = abstractGraphicalEditPart.resolveDiagramElement().eAllContents();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof org.eclipse.sirius.viewpoint.BasicLabelStyle)) continue;
            org.eclipse.sirius.viewpoint.BasicLabelStyle basicLabelStyle = (org.eclipse.sirius.viewpoint.BasicLabelStyle)object;
            this.updateBasicLabelStyle((BasicLabelStyle)labelStyle, basicLabelStyle, (AbstractGraphicalEditPart)abstractGraphicalEditPart);
            break;
        }
    }

    private void updateBorderedStyle(BorderedStyle borderedStyle, IDiagramElementEditPart abstractGraphicalEditPart) {
        IFigure figure = abstractGraphicalEditPart.getFigure();
        int borderSize = 0;
        Color borderColor = null;
        Border border = figure.getBorder();
        if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            borderSize = lineBorder.getWidth();
            borderColor = lineBorder.getColor();
        }
        borderedStyle.setBorderSize(borderSize);
        if (borderColor != null) {
            org.eclipse.sirius.tests.sample.migration.migrationmodeler.Color color = MigrationmodelerFactory.eINSTANCE.createColor();
            color.setRed(borderColor.getRed());
            color.setGreen(borderColor.getGreen());
            color.setBlue(borderColor.getBlue());
            borderedStyle.setBorderColor(color);
        }
    }

    private void updateLayout(AbstractRepresentation abstractRepresentation, IFigure figure) {
        Layout layout = MigrationmodelerFactory.eINSTANCE.createLayout();
        abstractRepresentation.setLayout(layout);
        Rectangle bounds = figure.getBounds();
        layout.setX(bounds.x);
        layout.setY(bounds.y);
        layout.setWidth(bounds.width);
        layout.setHeight(bounds.height);
    }

    private BasicLabelStyle getMigrationBasicLabelStyle(org.eclipse.sirius.viewpoint.BasicLabelStyle viewpointBasicLabelStyle, AbstractDEdgeNameEditPart abstractDEdgeNameEditPart) {
        BasicLabelStyle migrationBeginLabelStyle = MigrationmodelerFactory.eINSTANCE.createBasicLabelStyle();
        this.updateBasicLabelStyle(migrationBeginLabelStyle, viewpointBasicLabelStyle, (AbstractGraphicalEditPart)abstractDEdgeNameEditPart);
        return migrationBeginLabelStyle;
    }

    private void updateBasicLabelStyle(BasicLabelStyle migrationBeginLabelStyle, org.eclipse.sirius.viewpoint.BasicLabelStyle viewpointBasicLabelStyle, AbstractGraphicalEditPart abstractGraphicalEditPart) {
        boolean isItalic;
        IFigure figure = abstractGraphicalEditPart.getFigure();
        Font font = figure.getFont();
        FontData fontData = font.getFontData()[0];
        int fontHeight = fontData.getHeight();
        migrationBeginLabelStyle.setLabelSize(fontHeight);
        boolean isBold = (fontData.getStyle() & 1) != 0;
        boolean bl = isItalic = (fontData.getStyle() & 2) != 0;
        if (isBold && isItalic) {
            migrationBeginLabelStyle.setLabelFormat(FontFormat.BOLD_ITALIC);
        } else if (isBold) {
            migrationBeginLabelStyle.setLabelFormat(FontFormat.BOLD);
        } else if (isItalic) {
            migrationBeginLabelStyle.setLabelFormat(FontFormat.ITALIC);
        } else {
            migrationBeginLabelStyle.setLabelFormat(FontFormat.NORMAL);
        }
        Color labelForegroundColor = figure.getForegroundColor();
        org.eclipse.sirius.tests.sample.migration.migrationmodeler.Color migrationLabelForegroundColor = MigrationmodelerFactory.eINSTANCE.createColor();
        migrationLabelForegroundColor.setRed(labelForegroundColor.getRed());
        migrationLabelForegroundColor.setGreen(labelForegroundColor.getGreen());
        migrationLabelForegroundColor.setBlue(labelForegroundColor.getBlue());
        migrationBeginLabelStyle.setLabelColor(migrationLabelForegroundColor);
        AbstractDiagramNameEditPart abstractDiagramNameEditPart = this.getAbstractDiagramNameEditPart(abstractGraphicalEditPart);
        if (abstractDiagramNameEditPart != null) {
            SiriusWrapLabel viewpointWrapLabel = (SiriusWrapLabel)abstractDiagramNameEditPart.getFigure();
            Image icon = viewpointWrapLabel.getIcon();
            migrationBeginLabelStyle.setShowIcon(icon != null);
            if (icon == null) {
                migrationBeginLabelStyle.setIconPath(viewpointBasicLabelStyle.getIconPath());
            } else {
                migrationBeginLabelStyle.setIconPath(this.getIconPath(viewpointBasicLabelStyle, abstractDiagramNameEditPart));
            }
        }
    }

    private AbstractDiagramNameEditPart getAbstractDiagramNameEditPart(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        AbstractDiagramNameEditPart abstractDiagramNameEditPart = null;
        if (abstractGraphicalEditPart instanceof AbstractDiagramNameEditPart) {
            abstractDiagramNameEditPart = (AbstractDiagramNameEditPart)abstractGraphicalEditPart;
        } else {
            for (Object obj : abstractGraphicalEditPart.getChildren()) {
                if (!(obj instanceof AbstractDiagramNameEditPart)) continue;
                abstractDiagramNameEditPart = (AbstractDiagramNameEditPart)obj;
                break;
            }
        }
        return abstractDiagramNameEditPart;
    }

    private String getIconPath(org.eclipse.sirius.viewpoint.BasicLabelStyle viewpointBasicLabelStyle, AbstractDiagramNameEditPart abstractDiagramNameEditPart) {
        String iconPath = "";
        String modelIconPath = viewpointBasicLabelStyle.getIconPath();
        IFigure figure = abstractDiagramNameEditPart.getFigure();
        if (figure instanceof SiriusWrapLabel) {
            File imageFile;
            SiriusWrapLabel viewpointWrapLabel = (SiriusWrapLabel)figure;
            Image icon = viewpointWrapLabel.getIcon();
            if (modelIconPath != null && modelIconPath.length() > 0 && (imageFile = FileProvider.getDefault().getFile((IPath)new Path(modelIconPath))) != null) {
                try {
                    Image image;
                    ImageDescriptor imageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor((URL)imageFile.toURI().toURL());
                    if (imageDescriptor == null) {
                        imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                    }
                    if (Draw2dToSiriusModelTransformer.areEqualImages(image = DiagramUIPlugin.getPlugin().getImage(imageDescriptor), icon)) {
                        iconPath = modelIconPath;
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return iconPath;
    }

    public static boolean areEqualImages(Image image1, Image image2) {
        boolean areSameImages;
        byte[] expectedData = image1.getImageData().data;
        byte[] currentData = image2.getImageData().data;
        boolean bl = areSameImages = expectedData.length == currentData.length;
        if (areSameImages) {
            int i = 0;
            while (i < expectedData.length && areSameImages) {
                areSameImages = areSameImages && expectedData[i] == currentData[i];
                ++i;
            }
        }
        return areSameImages;
    }

    private DEdgeBeginNameEditPart getDEdgeBeginNameEditPart(AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart) {
        DEdgeBeginNameEditPart dEdgeBeginNameEditPart = null;
        for (Object child : abstractDiagramEdgeEditPart.getChildren()) {
            if (!(child instanceof DEdgeBeginNameEditPart)) continue;
            dEdgeBeginNameEditPart = (DEdgeBeginNameEditPart)child;
            break;
        }
        return dEdgeBeginNameEditPart;
    }

    private DEdgeNameEditPart getDEdgeCenterNameEditPart(AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart) {
        DEdgeNameEditPart dEdgeCenterNameEditPart = null;
        for (Object child : abstractDiagramEdgeEditPart.getChildren()) {
            if (!(child instanceof DEdgeNameEditPart)) continue;
            dEdgeCenterNameEditPart = (DEdgeNameEditPart)child;
            break;
        }
        return dEdgeCenterNameEditPart;
    }

    private DEdgeEndNameEditPart getDEdgeEndNameEditPart(AbstractDiagramEdgeEditPart abstractDiagramEdgeEditPart) {
        DEdgeEndNameEditPart dEdgeEndNameEditPart = null;
        for (Object child : abstractDiagramEdgeEditPart.getChildren()) {
            if (!(child instanceof DEdgeEndNameEditPart)) continue;
            dEdgeEndNameEditPart = (DEdgeEndNameEditPart)child;
            break;
        }
        return dEdgeEndNameEditPart;
    }

    private void setLayers(DSemanticDiagram dSemanticDiagram, Diagram migrationDiagram) {
        EList activatedLayers = dSemanticDiagram.getActivatedLayers();
        migrationDiagram.getLayers().clear();
        for (org.eclipse.sirius.diagram.description.Layer layer : activatedLayers) {
            Layer migrationLayer = MigrationmodelerFactory.eINSTANCE.createLayer();
            migrationLayer.setId(layer.getName());
            migrationLayer.setActivated(true);
            migrationDiagram.getLayers().add((Object)migrationLayer);
        }
        ArrayList allLayers = new ArrayList(LayerModelHelper.getAllLayers((DiagramDescription)dSemanticDiagram.getDescription()));
        allLayers.removeAll((Collection<?>)activatedLayers);
        for (org.eclipse.sirius.diagram.description.Layer layer : allLayers) {
            Layer migrationLayer = MigrationmodelerFactory.eINSTANCE.createLayer();
            migrationLayer.setId(layer.getName());
            migrationLayer.setActivated(false);
            migrationDiagram.getLayers().add((Object)migrationLayer);
        }
    }

    private void setFilters(DSemanticDiagram dSemanticDiagram, Diagram migrationDiagram) {
        EList activatedFilters = dSemanticDiagram.getActivatedFilters();
        migrationDiagram.getFilters().clear();
        for (FilterDescription filterDescription : activatedFilters) {
            Filter migrationFilter = MigrationmodelerFactory.eINSTANCE.createFilter();
            migrationFilter.setId(filterDescription.getName());
            migrationFilter.setActivated(true);
            migrationDiagram.getFilters().add((Object)migrationFilter);
        }
        ArrayList allFilters = new ArrayList(dSemanticDiagram.getDescription().getFilters());
        allFilters.removeAll((Collection<?>)activatedFilters);
        for (FilterDescription filterDescription : allFilters) {
            Filter migrationFilter = MigrationmodelerFactory.eINSTANCE.createFilter();
            migrationFilter.setId(filterDescription.getName());
            migrationFilter.setActivated(false);
            migrationDiagram.getFilters().add((Object)migrationFilter);
        }
    }

    private boolean isPresentInDiagram(AbstractRepresentation element, DSemanticDiagram diagram) {
        for (DDiagramElement diagramElement : diagram.getDiagramElements()) {
            if (!diagramElement.getTarget().equals(element)) continue;
            return true;
        }
        return false;
    }
}

