/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.BorderNodeCollapseManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;

public class MoveEdgeGroupManager {
    public static final String EDGE_GROUP_MOVE_KEY = "EDGE_GROUP_MOVE";
    public static final String EDGE_MOVE_DELTA = "EDGE_MOVE_DELTA";
    public static final String EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY = "EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY";
    private Request request;
    private int direction = 0;

    public MoveEdgeGroupManager(Request request) {
        this.request = request;
    }

    public boolean isToolActivated() {
        Object value = this.request.getExtendedData().get(EDGE_GROUP_MOVE_KEY);
        return value != null && Boolean.TRUE.equals(value);
    }

    public void showGroupFeedback() {
        if (this.accept()) {
            ConnectionEditPart connectionEditPart = ((BendpointRequest)this.request).getSource();
            for (ConnectionEditPart selectedConnectionEditPart : Iterables.filter((Iterable)connectionEditPart.getViewer().getSelectedEditParts(), ConnectionEditPart.class)) {
                this.showGroupFeedback(selectedConnectionEditPart);
            }
        }
    }

    private void showGroupFeedback(ConnectionEditPart connectionEditPart) {
        AbstractDiagramBorderNodeEditPart sourceEditPart = (AbstractDiagramBorderNodeEditPart)connectionEditPart.getSource();
        AbstractDiagramBorderNodeEditPart targetEditPart = (AbstractDiagramBorderNodeEditPart)connectionEditPart.getTarget();
        LinkedHashSet<EditPart> movedBorderNodes = new LinkedHashSet<EditPart>();
        for (ConnectionEditPart cep : Iterables.filter((Iterable)sourceEditPart.getViewer().getSelectedEditParts(), ConnectionEditPart.class)) {
            movedBorderNodes.add(cep.getSource());
            movedBorderNodes.add(cep.getTarget());
        }
        ChangeBoundsRequest sourceChangeBoundsRequest = this.createChangeBoundsRequest(sourceEditPart, movedBorderNodes);
        ChangeBoundsRequest targetChangeBoundsRequest = this.createChangeBoundsRequest(targetEditPart, movedBorderNodes);
        sourceEditPart.showSourceFeedback((Request)sourceChangeBoundsRequest);
        targetEditPart.showSourceFeedback((Request)targetChangeBoundsRequest);
    }

    public void eraseGroupFeedback() {
        if (this.request instanceof BendpointRequest && this.isToolActivatedOrHasBeenActivated()) {
            ConnectionEditPart connectionEditPart = ((BendpointRequest)this.request).getSource();
            for (ConnectionEditPart selectedConnectionEditPart : Iterables.filter((Iterable)connectionEditPart.getViewer().getSelectedEditParts(), ConnectionEditPart.class)) {
                this.eraseGroupFeedback(selectedConnectionEditPart);
            }
        }
    }

    private void eraseGroupFeedback(ConnectionEditPart connectionEditPart) {
        EditPart sourceEditPart = connectionEditPart.getSource();
        EditPart targetEditPart = connectionEditPart.getTarget();
        if (sourceEditPart instanceof AbstractDiagramBorderNodeEditPart && targetEditPart instanceof AbstractDiagramBorderNodeEditPart) {
            AbstractDiagramBorderNodeEditPart sourceBorderNodeEditPart = (AbstractDiagramBorderNodeEditPart)sourceEditPart;
            AbstractDiagramBorderNodeEditPart targetBorderNodeEditPart = (AbstractDiagramBorderNodeEditPart)targetEditPart;
            ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"drop");
            sourceBorderNodeEditPart.eraseSourceFeedback((Request)changeBoundsRequest);
            targetBorderNodeEditPart.eraseSourceFeedback((Request)changeBoundsRequest);
        }
    }

    public Command getCommand() {
        if (this.accept()) {
            ConnectionEditPart connectionEditPart = ((BendpointRequest)this.request).getSource();
            CompoundCommand cc = new CompoundCommand(Messages.EdgeGroupMoveMessage);
            for (ConnectionEditPart selectedConnectionEditPart : Iterables.filter((Iterable)connectionEditPart.getViewer().getSelectedEditParts(), ConnectionEditPart.class)) {
                cc.add(this.getCommand(selectedConnectionEditPart));
            }
            return cc;
        }
        return null;
    }

    private Command getCommand(ConnectionEditPart connectionEditPart) {
        Command tgtCommand;
        EditPart sourceEditPart = connectionEditPart.getSource();
        EditPart targetEditPart = connectionEditPart.getTarget();
        Command srcCommand = this.createCommand((AbstractDiagramBorderNodeEditPart)sourceEditPart);
        if (srcCommand != null && (tgtCommand = this.createCommand((AbstractDiagramBorderNodeEditPart)targetEditPart)) != null) {
            srcCommand = srcCommand.chain(tgtCommand);
            return srcCommand;
        }
        return null;
    }

    private boolean isToolActivatedOrHasBeenActivated() {
        Object value = this.request.getExtendedData().get(EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY);
        return value != null && Boolean.TRUE.equals(value);
    }

    private boolean accept() {
        if (this.request instanceof BendpointRequest) {
            ConnectionEditPart connectionEditPart = ((BendpointRequest)this.request).getSource();
            LinkedHashSet edgeDirections = new LinkedHashSet();
            boolean result = connectionEditPart.getViewer().getSelectedEditParts().stream().allMatch(part -> {
                ConnectionEditPart selectedConnection;
                return part instanceof ConnectionEditPart && this.checkConnectionEditpart(selectedConnection = (ConnectionEditPart)part, edgeDirections);
            });
            return result && edgeDirections.size() == 1;
        }
        return false;
    }

    private boolean checkConnectionEditpart(ConnectionEditPart input, Set<Integer> edgeDirections) {
        int targetDirection;
        int sourceDirection;
        EditPart sourceEditPart = input.getSource();
        EditPart targetEditPart = input.getTarget();
        if (sourceEditPart instanceof AbstractDiagramBorderNodeEditPart && targetEditPart instanceof AbstractDiagramBorderNodeEditPart && this.getAllConnections((AbstractDiagramBorderNodeEditPart)sourceEditPart).size() == 1 && this.getAllConnections((AbstractDiagramBorderNodeEditPart)targetEditPart).size() == 1 && (sourceDirection = this.getBorderNodeDirection((AbstractDiagramBorderNodeEditPart)sourceEditPart)) == (targetDirection = this.getBorderNodeDirection((AbstractDiagramBorderNodeEditPart)targetEditPart))) {
            this.direction = sourceDirection;
            edgeDirections.add(sourceDirection);
            return true;
        }
        return false;
    }

    private Command createCommand(AbstractDiagramBorderNodeEditPart editPart) {
        LayoutConstraint layoutConstraint;
        Object model = editPart.getModel();
        if (model instanceof Node && (layoutConstraint = ((Node)model).getLayoutConstraint()) instanceof Location) {
            PrecisionPoint delta = this.getDeltaFromRequest();
            double scale = this.getZoomScale(editPart);
            if (!this.conflictDetected(editPart, (Point)(delta = delta.setPreciseLocation((double)Math.round((double)delta.x() / scale), (double)Math.round((double)delta.y() / scale))))) {
                Point location = new Point(((Location)layoutConstraint).getX(), ((Location)layoutConstraint).getY());
                Point newLocation = location.translate((Point)delta);
                SetBoundsCommand moveCommand = new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), newLocation);
                return new ICommandProxy((ICommand)moveCommand);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean conflictDetected(AbstractDiagramBorderNodeEditPart editPart, Point moveDelta) {
        BorderNodeCollapseManager borderNodeCollapseManager = new BorderNodeCollapseManager();
        IBorderItemLocator locator = editPart.getBorderItemLocator();
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        bounds.translate(moveDelta);
        Rectangle newBounds = borderNodeCollapseManager.expandCollapsedNodeBounds((IBorderItemEditPart)editPart, new PrecisionRectangle(bounds));
        if (newBounds != null) {
            bounds.setBounds(newBounds);
        }
        ArrayList<IFigure> figureToIgnore = new ArrayList<IFigure>();
        figureToIgnore.add(figure);
        for (ConnectionEditPart connectionEditPart : Iterables.filter((Iterable)editPart.getViewer().getSelectedEditParts(), ConnectionEditPart.class)) {
            EditPart source = connectionEditPart.getSource();
            EditPart target = connectionEditPart.getTarget();
            if (source instanceof AbstractDiagramBorderNodeEditPart && source.getParent().equals(editPart.getParent())) {
                figureToIgnore.add(((AbstractDiagramBorderNodeEditPart)source).getFigure());
            }
            if (!(target instanceof AbstractDiagramBorderNodeEditPart) || !target.getParent().equals(editPart.getParent())) continue;
            figureToIgnore.add(((AbstractDiagramBorderNodeEditPart)target).getFigure());
        }
        Rectangle validLocation = ((DBorderItemLocator)locator).getValidLocation(bounds, figure, figureToIgnore, Collections.emptyList());
        if (borderNodeCollapseManager.hasBeenExpanded()) {
            borderNodeCollapseManager.restoreCollapsedNode((IBorderItemEditPart)editPart);
        }
        return !validLocation.equals((Object)bounds);
    }

    private double getZoomScale(AbstractDiagramBorderNodeEditPart editPart) {
        ZoomManager zoomManager = editPart.getZoomManager();
        if (zoomManager != null) {
            return zoomManager.getZoom();
        }
        return 1.0;
    }

    private ChangeBoundsRequest createChangeBoundsRequest(AbstractDiagramBorderNodeEditPart editPart, Set<EditPart> additionalEditParts) {
        ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"move");
        ArrayList<AbstractDiagramBorderNodeEditPart> allEditParts = new ArrayList<AbstractDiagramBorderNodeEditPart>(1 + additionalEditParts.size());
        allEditParts.add(editPart);
        allEditParts.addAll(additionalEditParts);
        changeBoundsRequest.setEditParts(allEditParts);
        PrecisionPoint moveDelta = this.getDeltaFromRequest();
        changeBoundsRequest.setMoveDelta((Point)moveDelta);
        changeBoundsRequest.setLocation(((BendpointRequest)this.request).getLocation());
        return changeBoundsRequest;
    }

    private PrecisionPoint getDeltaFromRequest() {
        Object delta = this.request.getExtendedData().get(EDGE_MOVE_DELTA);
        Point moveDelta = new Point();
        if (delta != null) {
            if (delta instanceof Dimension) {
                moveDelta.setX(((Dimension)delta).width());
                moveDelta.setY(((Dimension)delta).height());
            }
            if (this.direction == 128) {
                moveDelta.setX(0);
            } else {
                moveDelta.setY(0);
            }
        }
        return new PrecisionPoint(moveDelta);
    }

    private List<Object> getAllConnections(AbstractDiagramBorderNodeEditPart borderNodeEditPart) {
        ArrayList<Object> connections = new ArrayList<Object>();
        connections.addAll(borderNodeEditPart.getSourceConnections());
        connections.addAll(borderNodeEditPart.getTargetConnections());
        return connections;
    }

    private int getBorderNodeDirection(AbstractDiagramBorderNodeEditPart borderNodeEditPart) {
        IBorderItemLocator borderItemLocator = borderNodeEditPart.getBorderItemLocator();
        int side = borderItemLocator.getCurrentSideOfParent();
        int localDirection = 0;
        switch (side) {
            case 16: {
                localDirection = 128;
                break;
            }
            case 8: {
                localDirection = 128;
                break;
            }
            case 1: {
                localDirection = 64;
                break;
            }
            case 4: {
                localDirection = 64;
                break;
            }
        }
        return localDirection;
    }
}

