/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.selection.page.EObjectSelectionWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SessionResourceCreationWizardPage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateSessionResourceWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected SessionResourceCreationWizardPage diagramModelFilePage;
    protected EObjectSelectionWizardPage viewpointSelectionPage;
    private IWorkbench workbench;
    private Session createdSession;

    public CreateSessionResourceWizard() {
    }

    public CreateSessionResourceWizard(IStructuredSelection initialSelection) {
        this.selection = initialSelection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = new StructuredSelection();
        }
        return this.selection;
    }

    public void init(IWorkbench w, IStructuredSelection s) {
        this.workbench = w;
        this.selection = s;
        this.setWindowTitle(Messages.CreateSessionResourceWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("odesign");
        this.diagramModelFilePage = new SessionResourceCreationWizardPage("DiagramModelFile", this.getSelection(), "aird");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public boolean performFinish() {
        DiagramFileCreationOperation op = new DiagramFileCreationOperation();
        boolean errorCatch = false;
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            errorCatch = true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CreateSessionResourceWizard_resourceCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SiriusTransPlugin.getPlugin().error(Messages.CreateSessionResourceWizard_sessionDataCreationError, e.getTargetException());
            }
            errorCatch = true;
        }
        if (errorCatch) {
            return false;
        }
        return this.createdSession != null;
    }

    public Session getCreatedSession() {
        return this.createdSession;
    }

    private class DiagramFileCreationOperation
    extends WorkspaceModifyOperation {
        DiagramFileCreationOperation() {
            super(null);
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(CreateSessionResourceWizard.this.diagramModelFilePage.getURI(), monitor);
            sessionCreationOperation.execute();
            CreateSessionResourceWizard.this.createdSession = sessionCreationOperation.getCreatedSession();
        }
    }
}

