/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceData;

public class DefaultCharsetUpdater {
    private final WorkspaceData wsData;
    private final IProgressMonitor nullMonitor = new NullProgressMonitor();
    private static final String propJavacDefaultEncodingForPlugin = DefaultCharsetUpdater.propJavacDefaultEncodingFor(".");

    public DefaultCharsetUpdater(WorkspaceData wsData) {
        this.wsData = wsData;
    }

    public void update(TaskingLog log) {
        for (PluginData plugin : this.wsData.getPlugins()) {
            IProject project = plugin.getProject();
            try {
                String pluginCharset = project.getDefaultCharset(false);
                if (pluginCharset == null) {
                    pluginCharset = project.getDefaultCharset(true);
                    if (pluginCharset == null) {
                        pluginCharset = "UTF-8";
                    }
                    project.setDefaultCharset(pluginCharset, this.nullMonitor);
                }
                this.setJavacDefaultEncodingInPDEBuildProperties(project, pluginCharset);
            }
            catch (CoreException e) {
                log.error("failed to update default charset for project " + project.getName(), (Throwable)e);
            }
        }
    }

    private void setJavacDefaultEncodingInPDEBuildProperties(IProject project, final String pluginCharset) throws CoreException {
        if (!this.isMissingJavacDefaultEncoding(project)) {
            return;
        }
        Display.getDefault().syncExec(() -> PDEModelUtility.modifyModel((ModelModification)new ModelModification(PDEProject.getBuildProperties((IProject)project)){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                IBuildModel buildModel = (IBuildModel)model.getAdapter(IBuildModel.class);
                if (!DefaultCharsetUpdater.this.isMissingJavacDefaultEncoding(buildModel)) {
                    return;
                }
                IBuildEntry buildProp = buildModel.getFactory().createEntry(propJavacDefaultEncodingForPlugin);
                buildProp.addToken(pluginCharset);
            }
        }, (IProgressMonitor)this.nullMonitor));
    }

    private boolean isMissingJavacDefaultEncoding(IProject project) {
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((IProject)project);
        if (pluginModelBase == null) {
            return false;
        }
        try {
            IBuildModel buildModel = PluginRegistry.createBuildModel((IPluginModelBase)pluginModelBase);
            return this.isMissingJavacDefaultEncoding(buildModel);
        }
        catch (CoreException e) {
            return false;
        }
    }

    private boolean isMissingJavacDefaultEncoding(IBuildModel buildModel) {
        if (buildModel == null) {
            return false;
        }
        IBuild build = buildModel.getBuild();
        if (!this.hasSourceLibs(build)) {
            return false;
        }
        IBuildEntry buildProp = build.getEntry(propJavacDefaultEncodingForPlugin);
        return buildProp == null;
    }

    private boolean hasSourceLibs(IBuild build) {
        if (build == null) {
            return false;
        }
        IBuildEntry[] iBuildEntryArray = build.getBuildEntries();
        int n = iBuildEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry entry = iBuildEntryArray[n2];
            if (entry.getName().startsWith("source.") && entry.getTokens().length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final String propJavacDefaultEncodingFor(String path) {
        return "javacDefaultEncoding." + path;
    }
}

