/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildElement;
import org.eclipse.tea.library.build.chain.TeaBuildProjectElement;
import org.eclipse.tea.library.build.chain.TeaClosedPluginElement;
import org.eclipse.tea.library.build.chain.TeaUnhandledElement;
import org.eclipse.tea.library.build.services.TeaBuildElementFactory;
import org.eclipse.tea.library.build.services.TeaBuildVisitor;
import org.eclipse.tea.library.build.services.TeaDependencyWireFactory;
import org.eclipse.tea.library.build.services.TeaElementFailurePolicy;
import org.eclipse.tea.library.build.services.TeaElementVisitPolicy;

public class TeaBuildChain {
    private final Map<String, TeaBuildElement> namedElements = new TreeMap<String, TeaBuildElement>();
    private final Map<Integer, List<TeaBuildElement>> groupedElements = new TreeMap<Integer, List<TeaBuildElement>>();
    private final List<TeaBuildVisitor> visitors;
    private final IEclipseContext context;
    private static final String PROJECTS_KEY = "TeaBuildChain.projectsToBuild";

    @Inject
    public TeaBuildChain(IEclipseContext context, TaskingLog log, @Named(value="TeaBuildChain.projectsToBuild") Collection<IProject> projectsToBuild, @Service List<TeaBuildElementFactory> elementFactories, @Service List<TeaDependencyWireFactory> dependencyFactories, @Service List<TeaBuildVisitor> visitors) {
        this.visitors = visitors;
        this.context = context;
        elementFactories.forEach(f -> {
            Object object = ContextInjectionFactory.invoke((Object)f, Execute.class, (IEclipseContext)context, null);
        });
        Arrays.stream(PluginRegistry.getActiveModels((boolean)false)).filter(model -> model.getUnderlyingResource() == null || !model.getUnderlyingResource().getProject().isOpen()).forEach(model -> {
            TeaClosedPluginElement e = new TeaClosedPluginElement((IPluginModelBase)model);
            this.namedElements.put(((TeaBuildElement)e).getName(), e);
        });
        for (IProject prj : projectsToBuild) {
            if (!prj.isOpen()) continue;
            List<TeaBuildElement> elements = elementFactories.stream().map(f -> f.createElements(this, prj)).filter(Objects::nonNull).flatMap(l -> l.stream()).filter(Objects::nonNull).collect(Collectors.toList());
            if (elements.isEmpty()) {
                elements.add(new TeaUnhandledElement(prj.getName()));
            }
            elements.forEach(e -> {
                TeaBuildElement teaBuildElement = this.namedElements.put(e.getName(), (TeaBuildElement)e);
            });
        }
        dependencyFactories.forEach(f -> {
            Object object = ContextInjectionFactory.invoke((Object)f, Execute.class, (IEclipseContext)context, null);
        });
        dependencyFactories.forEach(f -> f.createWires(this));
        this.namedElements.values().forEach(e -> {
            boolean bl = this.groupedElements.computeIfAbsent(e.getBuildOrder(new ArrayDeque<TeaBuildElement>()), ArrayList::new).add(e);
        });
    }

    public static TeaBuildChain make(IEclipseContext ctx, Collection<IProject> projectsToBuild) {
        IEclipseContext context = ctx.createChild("TeaBuildChain");
        context.set(PROJECTS_KEY, projectsToBuild);
        TeaBuildChain chain = (TeaBuildChain)ContextInjectionFactory.make(TeaBuildChain.class, (IEclipseContext)context);
        context.set(TeaBuildChain.class, (Object)chain);
        return chain;
    }

    public List<String> getBuildOrder() {
        return this.groupedElements.values().stream().flatMap(teaBuildElement -> teaBuildElement.stream().filter(e -> e instanceof TeaBuildProjectElement).map(e -> ((TeaBuildProjectElement)e).getProject().getName())).collect(Collectors.toList());
    }

    public List<List<String>> getBuildingGroupNames(String projecPrefixToSkip) {
        return this.groupedElements.entrySet().stream().sorted(Comparator.comparing(e -> (Integer)e.getKey())).map(e -> ((List)e.getValue()).stream().filter(el -> !(el instanceof TeaClosedPluginElement | el instanceof TeaUnhandledElement)).map(el -> el.getName().replaceFirst(Pattern.quote(projecPrefixToSkip), "")).sorted().collect(Collectors.toList())).filter(l -> !l.isEmpty()).collect(Collectors.toList());
    }

    public TeaBuildElement getElementFor(String name) {
        return this.namedElements.get(name);
    }

    public Collection<TeaBuildElement> getAllElements() {
        return this.namedElements.values();
    }

    public int getTotalProgress() {
        return this.groupedElements.size();
    }

    public IStatus execute(TaskProgressTracker tracker, long failureThreshold) {
        MultiStatus ms = new MultiStatus("org.eclipse.tea.library.build", 0, "Build", null);
        this.context.set(IStatus.class, (Object)ms);
        for (TeaBuildVisitor visitor : this.visitors) {
            ContextInjectionFactory.invoke((Object)visitor, Execute.class, (IEclipseContext)this.context, null);
        }
        long failures = 0L;
        for (Map.Entry<Integer, List<TeaBuildElement>> entry : this.groupedElements.entrySet()) {
            if (tracker.isCanceled()) {
                throw new OperationCanceledException();
            }
            tracker.setTaskName("Processing Group " + String.valueOf(entry.getKey()));
            for (TeaBuildVisitor visitor : this.visitors) {
                for (TeaBuildElement e : entry.getValue()) {
                    if (this.getVisitPolicyFor(e) != TeaElementVisitPolicy.VisitPolicy.ABORT_IF_PREVIOUS_ERROR || ms.getSeverity() <= 2) continue;
                    ms.add((IStatus)new Status(ms.getSeverity(), "org.eclipse.tea.library.build", "Abort prior to executing " + e.getName() + " due to previous error"));
                    return ms;
                }
                Map results = Optional.of(visitor.visit(entry.getValue())).orElse(Collections.emptyMap());
                for (Map.Entry result : results.entrySet()) {
                    IStatus status = (IStatus)result.getValue();
                    if (status.getSeverity() <= 2) continue;
                    TeaBuildElement element = (TeaBuildElement)result.getKey();
                    switch (TeaBuildChain.getFailurePolicyFor(element)) {
                        case ABORT_IMMEDIATE: {
                            ms.add(status);
                            return ms;
                        }
                        case IGNORE: {
                            ms.add((IStatus)new Status(2, "org.eclipse.tea.library.build", "Ignored failure in element " + element.getName()));
                            break;
                        }
                        case USE_THRESHOLD: {
                            ms.add(status);
                            if (failures++ < failureThreshold) break;
                            return ms;
                        }
                    }
                }
            }
            tracker.worked(1);
        }
        return ms;
    }

    public static TeaElementFailurePolicy.FailurePolicy getFailurePolicyFor(TeaBuildElement element) {
        TeaElementFailurePolicy a = element.getClass().getAnnotation(TeaElementFailurePolicy.class);
        if (a == null) {
            return TeaElementFailurePolicy.FailurePolicy.USE_THRESHOLD;
        }
        return a.value();
    }

    private TeaElementVisitPolicy.VisitPolicy getVisitPolicyFor(TeaBuildElement element) {
        TeaElementVisitPolicy a = element.getClass().getAnnotation(TeaElementVisitPolicy.class);
        if (a == null) {
            return TeaElementVisitPolicy.VisitPolicy.USE_THRESHOLD;
        }
        return a.value();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(":\n");
        this.groupedElements.forEach((g, e) -> e.forEach(x -> {
            StringBuilder stringBuilder2 = builder.append("\t").append(g).append(": ").append(x.getName()).append("\n");
        }));
        return builder.toString();
    }
}

