/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

@Deprecated(forRemoval=true, since="2025-03")
public class DefaultPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    @Deprecated
    public static final String CONTENT_TYPES_CATEGORY = "__content_types_category";
    @Deprecated
    protected IPartitionTokenScanner fScanner;
    @Deprecated
    protected String[] fLegalContentTypes;
    @Deprecated
    protected IDocument fDocument;
    @Deprecated
    protected int fPreviousDocumentLength;
    @Deprecated
    protected DefaultPositionUpdater fPositionUpdater;
    @Deprecated
    protected int fStartOffset;
    @Deprecated
    protected int fEndOffset;
    @Deprecated
    protected int fDeleteOffset;
    private final String fPositionCategory;
    private DocumentRewriteSession fActiveRewriteSession;
    private boolean fIsInitialized = false;

    @Deprecated
    public DefaultPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        this.fScanner = scanner;
        this.fLegalContentTypes = TextUtilities.copy(legalContentTypes);
        this.fPositionCategory = CONTENT_TYPES_CATEGORY + this.hashCode();
        this.fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    }

    @Override
    @Deprecated
    public String[] getManagingPositionCategories() {
        return new String[]{this.fPositionCategory};
    }

    @Override
    @Deprecated
    public void connect(IDocument document) {
        this.connect(document, false);
    }

    @Override
    @Deprecated
    public void connect(IDocument document, boolean delayInitialization) {
        Assert.isNotNull((Object)document);
        Assert.isTrue((!document.containsPositionCategory(this.fPositionCategory) ? 1 : 0) != 0);
        this.fDocument = document;
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
        if (!delayInitialization) {
            this.checkInitialization();
        }
    }

    @Deprecated
    protected final void checkInitialization() {
        if (!this.fIsInitialized) {
            this.initialize();
        }
    }

    @Deprecated
    protected void initialize() {
        this.fIsInitialized = true;
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            IToken token = this.fScanner.nextToken();
            while (!token.isEOF()) {
                String contentType = this.getTokenContentType(token);
                if (this.isSupportedContentType(contentType)) {
                    TypedPosition p = new TypedPosition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), contentType);
                    this.fDocument.addPosition(this.fPositionCategory, p);
                }
                token = this.fScanner.nextToken();
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void disconnect() {
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(this.fPositionCategory));
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void documentAboutToBeChanged(DocumentEvent e) {
        if (this.fIsInitialized) {
            Assert.isTrue((e.getDocument() == this.fDocument ? 1 : 0) != 0);
            this.fPreviousDocumentLength = e.getDocument().getLength();
            this.fStartOffset = -1;
            this.fEndOffset = -1;
            this.fDeleteOffset = -1;
        }
    }

    @Override
    @Deprecated
    public boolean documentChanged(DocumentEvent e) {
        if (this.fIsInitialized) {
            IRegion region = this.documentChanged2(e);
            return region != null;
        }
        return false;
    }

    private void rememberRegion(int offset, int length) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = offset;
        } else if (offset < this.fStartOffset) {
            this.fStartOffset = offset;
        }
        int endOffset = offset + length;
        if (this.fEndOffset == -1) {
            this.fEndOffset = endOffset;
        } else if (endOffset > this.fEndOffset) {
            this.fEndOffset = endOffset;
        }
    }

    private void rememberDeletedOffset(int offset) {
        this.fDeleteOffset = offset;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int offset = Math.min(this.fDeleteOffset, this.fStartOffset);
        int endOffset = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(offset, endOffset - offset);
    }

    @Override
    @Deprecated
    public IRegion documentChanged2(DocumentEvent e) {
        if (!this.fIsInitialized) {
            return null;
        }
        try {
            IDocument d = e.getDocument();
            Position[] category = d.getPositions(this.fPositionCategory);
            IRegion line = d.getLineInformationOfOffset(e.getOffset());
            int reparseStart = line.getOffset();
            int partitionStart = -1;
            String contentType = null;
            int newLength = e.getText() == null ? 0 : e.getText().length();
            int first = d.computeIndexInCategory(this.fPositionCategory, reparseStart);
            if (first > 0) {
                TypedPosition partition = (TypedPosition)category[first - 1];
                if (partition.includes(reparseStart)) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    if (e.getOffset() == partition.getOffset() + partition.getLength()) {
                        reparseStart = partitionStart;
                    }
                    --first;
                } else if (reparseStart == e.getOffset() && reparseStart == partition.getOffset() + partition.getLength()) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    reparseStart = partitionStart;
                    --first;
                } else {
                    partitionStart = partition.getOffset() + partition.getLength();
                    contentType = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(e);
            int i = first;
            while (i < category.length) {
                Position p = category[i];
                if (p.isDeleted) {
                    this.rememberDeletedOffset(e.getOffset());
                    break;
                }
                ++i;
            }
            category = d.getPositions(this.fPositionCategory);
            this.fScanner.setPartialRange(d, reparseStart, d.getLength() - reparseStart, contentType, partitionStart);
            int lastScannedPosition = reparseStart;
            IToken token = this.fScanner.nextToken();
            while (!token.isEOF()) {
                contentType = this.getTokenContentType(token);
                if (!this.isSupportedContentType(contentType)) {
                    token = this.fScanner.nextToken();
                    continue;
                }
                int start = this.fScanner.getTokenOffset();
                int length = this.fScanner.getTokenLength();
                lastScannedPosition = start + length - 1;
                while (first < category.length) {
                    TypedPosition p = (TypedPosition)category[first];
                    if (lastScannedPosition < p.offset + p.length && (!p.overlapsWith(start, length) || d.containsPosition(this.fPositionCategory, start, length) && contentType.equals(p.getType()))) break;
                    this.rememberRegion(p.offset, p.length);
                    d.removePosition(this.fPositionCategory, p);
                    ++first;
                }
                if (d.containsPosition(this.fPositionCategory, start, length)) {
                    if (lastScannedPosition >= e.getOffset() + newLength) {
                        return this.createRegion();
                    }
                    ++first;
                } else {
                    try {
                        d.addPosition(this.fPositionCategory, new TypedPosition(start, length, contentType));
                        this.rememberRegion(start, length);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                token = this.fScanner.nextToken();
            }
            if (lastScannedPosition != reparseStart) {
                ++lastScannedPosition;
            }
            first = d.computeIndexInCategory(this.fPositionCategory, lastScannedPosition);
            category = d.getPositions(this.fPositionCategory);
            while (first < category.length) {
                TypedPosition p = (TypedPosition)category[first++];
                d.removePosition(this.fPositionCategory, p);
                this.rememberRegion(p.offset, p.length);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.createRegion();
    }

    @Deprecated
    protected TypedPosition findClosestPosition(int offset) {
        Position[] category;
        int index;
        block6: {
            index = this.fDocument.computeIndexInCategory(this.fPositionCategory, offset);
            category = this.fDocument.getPositions(this.fPositionCategory);
            if (category.length != 0) break block6;
            return null;
        }
        try {
            if (index < category.length && offset == category[index].offset) {
                return (TypedPosition)category[index];
            }
            if (index > 0) {
                --index;
            }
            return (TypedPosition)category[index];
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Deprecated
    public String getContentType(int offset) {
        this.checkInitialization();
        TypedPosition p = this.findClosestPosition(offset);
        if (p != null && p.includes(offset)) {
            return p.getType();
        }
        return "__dftl_partition_content_type";
    }

    @Override
    @Deprecated
    public ITypedRegion getPartition(int offset) {
        this.checkInitialization();
        try {
            Position[] category = this.fDocument.getPositions(this.fPositionCategory);
            if (category == null || category.length == 0) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            int index = this.fDocument.computeIndexInCategory(this.fPositionCategory, offset);
            if (index < category.length) {
                TypedPosition next = (TypedPosition)category[index];
                if (offset == next.offset) {
                    return new TypedRegion(next.getOffset(), next.getLength(), next.getType());
                }
                if (index == 0) {
                    return new TypedRegion(0, next.offset, "__dftl_partition_content_type");
                }
                TypedPosition previous = (TypedPosition)category[index - 1];
                if (previous.includes(offset)) {
                    return new TypedRegion(previous.getOffset(), previous.getLength(), previous.getType());
                }
                int endOffset = previous.getOffset() + previous.getLength();
                return new TypedRegion(endOffset, next.getOffset() - endOffset, "__dftl_partition_content_type");
            }
            TypedPosition previous = (TypedPosition)category[category.length - 1];
            if (previous.includes(offset)) {
                return new TypedRegion(previous.getOffset(), previous.getLength(), previous.getType());
            }
            int endOffset = previous.getOffset() + previous.getLength();
            return new TypedRegion(endOffset, this.fDocument.getLength() - endOffset, "__dftl_partition_content_type");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
    }

    @Override
    @Deprecated
    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, false);
    }

    @Override
    @Deprecated
    public String[] getLegalContentTypes() {
        return TextUtilities.copy(this.fLegalContentTypes);
    }

    @Deprecated
    protected boolean isSupportedContentType(String contentType) {
        if (contentType != null) {
            String[] stringArray = this.fLegalContentTypes;
            int n = this.fLegalContentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String fLegalContentType = stringArray[n2];
                if (fLegalContentType.equals(contentType)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Deprecated
    protected String getTokenContentType(IToken token) {
        Object data = token.getData();
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    @Override
    @Deprecated
    public String getContentType(int offset, boolean preferOpenPartitions) {
        return this.getPartition(offset, preferOpenPartitions).getType();
    }

    @Override
    @Deprecated
    public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
        ITypedRegion region = this.getPartition(offset);
        if (preferOpenPartitions && region.getOffset() == offset && !region.getType().equals("__dftl_partition_content_type")) {
            if (offset > 0 && (region = this.getPartition(offset - 1)).getType().equals("__dftl_partition_content_type")) {
                return region;
            }
            return new TypedRegion(offset, 0, "__dftl_partition_content_type");
        }
        return region;
    }

    @Override
    @Deprecated
    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        this.checkInitialization();
        ArrayList<TypedRegion> list = new ArrayList<TypedRegion>();
        try {
            int end;
            int start;
            int gapOffset;
            int endOffset = offset + length;
            Position[] category = this.fDocument.getPositions(this.fPositionCategory);
            Position previous = null;
            TypedPosition current = null;
            Position gap = new Position(0);
            int startIndex = this.getFirstIndexEndingAfterOffset(category, offset);
            int endIndex = this.getFirstIndexStartingAfterOffset(category, endOffset);
            int i = startIndex;
            while (i < endIndex) {
                current = (TypedPosition)category[i];
                gapOffset = previous != null ? previous.getOffset() + previous.getLength() : 0;
                gap.setOffset(gapOffset);
                gap.setLength(current.getOffset() - gapOffset);
                if (includeZeroLengthPartitions && this.overlapsOrTouches(gap, offset, length) || gap.getLength() > 0 && gap.overlapsWith(offset, length)) {
                    start = Math.max(offset, gapOffset);
                    end = Math.min(endOffset, gap.getOffset() + gap.getLength());
                    list.add(new TypedRegion(start, end - start, "__dftl_partition_content_type"));
                }
                if (current.overlapsWith(offset, length)) {
                    start = Math.max(offset, current.getOffset());
                    end = Math.min(endOffset, current.getOffset() + current.getLength());
                    list.add(new TypedRegion(start, end - start, current.getType()));
                }
                previous = current;
                ++i;
            }
            if (previous != null) {
                gapOffset = previous.getOffset() + previous.getLength();
                gap.setOffset(gapOffset);
                gap.setLength(this.fDocument.getLength() - gapOffset);
                if (includeZeroLengthPartitions && this.overlapsOrTouches(gap, offset, length) || gap.getLength() > 0 && gap.overlapsWith(offset, length)) {
                    start = Math.max(offset, gapOffset);
                    end = Math.min(endOffset, this.fDocument.getLength());
                    list.add(new TypedRegion(start, end - start, "__dftl_partition_content_type"));
                }
            }
            if (list.isEmpty()) {
                list.add(new TypedRegion(offset, length, "__dftl_partition_content_type"));
            }
        }
        catch (BadPositionCategoryException endOffset) {
            // empty catch block
        }
        ITypedRegion[] result = new TypedRegion[list.size()];
        list.toArray(result);
        return result;
    }

    private boolean overlapsOrTouches(Position gap, int offset, int length) {
        return gap.getOffset() <= offset + length && offset <= gap.getOffset() + gap.getLength();
    }

    private int getFirstIndexEndingAfterOffset(Position[] positions, int offset) {
        int i = -1;
        int j = positions.length;
        while (j - i > 1) {
            int k = i + j >> 1;
            Position p = positions[k];
            if (p.getOffset() + p.getLength() > offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    private int getFirstIndexStartingAfterOffset(Position[] positions, int offset) {
        int i = -1;
        int j = positions.length;
        while (j - i > 1) {
            int k = i + j >> 1;
            Position p = positions[k];
            if (p.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    @Override
    @Deprecated
    public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
        if (this.fActiveRewriteSession != null) {
            throw new IllegalStateException();
        }
        this.fActiveRewriteSession = session;
    }

    @Override
    @Deprecated
    public void stopRewriteSession(DocumentRewriteSession session) {
        if (this.fActiveRewriteSession == session) {
            this.flushRewriteSession();
        }
    }

    @Override
    @Deprecated
    public DocumentRewriteSession getActiveRewriteSession() {
        return this.fActiveRewriteSession;
    }

    @Deprecated
    protected final void flushRewriteSession() {
        this.fActiveRewriteSession = null;
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
    }
}

