/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.xml.sax.Attributes;

public abstract class SaxTaskListElementBuilder<T extends IRepositoryElement> {
    private String currentAttributeKey;
    private StringBuilder currentAttributeValue;
    private final MultiStatus errors = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, null, null);

    protected SaxTaskListElementBuilder() {
    }

    public abstract void beginItem(Attributes var1);

    protected abstract void applyAttribute(String var1, String var2);

    public abstract T getItem();

    public abstract void addToTaskList(ITransferList var1);

    public void startAttribute(Attributes elementAttributes) {
        this.currentAttributeKey = elementAttributes.getValue("Key");
        this.currentAttributeValue = new StringBuilder();
    }

    public void acceptAttributeValueContent(char[] content, int start, int length) {
        if (this.isAcceptingAttributeValues()) {
            this.currentAttributeValue.append(content, start, length);
        }
    }

    public void endAttribute() {
        if (this.isAcceptingAttributeValues()) {
            this.applyAttribute(this.currentAttributeKey, this.currentAttributeValue.toString());
        }
        this.currentAttributeKey = null;
        this.currentAttributeValue = null;
    }

    public boolean isAcceptingAttributeValues() {
        return this.currentAttributeKey != null && this.currentAttributeValue != null;
    }

    protected void addError(IStatus status) {
        this.errors.add(status);
    }

    public IStatus getErrors() {
        return this.errors;
    }
}

