/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ErrorDialogWithToggle;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HotCodeReplaceErrorDialog
extends ErrorDialogWithToggle
implements IDebugEventSetListener {
    protected IDebugTarget target;
    protected int TERMINATE_ID = 14;
    protected int DISCONNECT_ID = this.TERMINATE_ID + 1;
    protected int RESTART_ID = this.TERMINATE_ID + 2;

    public HotCodeReplaceErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, String toggleMessage2, IPreferenceStore store, IDebugTarget target) {
        super(parentShell, dialogTitle, message, status, preferenceKey, toggleMessage, toggleMessage2, store);
        this.target = target;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(DebugUIMessages.HotCodeReplaceErrorDialog_0);
        boolean canTerminate = this.target.canTerminate();
        boolean canDisconnect = this.target.canDisconnect();
        GridData data = new GridData(0x1000000);
        data.horizontalAlignment = 2;
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        if (canTerminate) {
            this.createButton(parent, this.TERMINATE_ID, DebugUIMessages.HotCodeReplaceErrorDialog_1, false);
        }
        if (canDisconnect) {
            this.createButton(parent, this.DISCONNECT_ID, DebugUIMessages.HotCodeReplaceErrorDialog_3, false);
        }
        if (canTerminate && !canDisconnect) {
            this.createButton(parent, this.RESTART_ID, DebugUIMessages.HotCodeReplaceErrorDialog_7, false);
        }
        this.blockMnemonicWithoutModifier(this.getToggleButton());
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        this.blockMnemonicWithoutModifier(button);
        return button;
    }

    protected void blockMnemonicWithoutModifier(Button button) {
        button.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit && e.stateMask != SWT.MOD3) {
                    e.doit = false;
                }
            }
        });
    }

    @Override
    protected void buttonPressed(final int id) {
        if (id == this.TERMINATE_ID || id == this.DISCONNECT_ID || id == this.RESTART_ID) {
            DebugException[] ex = new DebugException[1];
            Object[] operation = new String[1];
            ex[0] = null;
            Runnable r = new Runnable((String[])operation, ex){
                private final /* synthetic */ String[] val$operation;
                private final /* synthetic */ DebugException[] val$ex;
                {
                    this.val$operation = stringArray;
                    this.val$ex = debugExceptionArray;
                }

                @Override
                public void run() {
                    try {
                        if (id == HotCodeReplaceErrorDialog.this.TERMINATE_ID) {
                            this.val$operation[0] = DebugUIMessages.HotCodeReplaceErrorDialog_5;
                            HotCodeReplaceErrorDialog.this.target.terminate();
                        } else if (id == HotCodeReplaceErrorDialog.this.DISCONNECT_ID) {
                            this.val$operation[0] = DebugUIMessages.HotCodeReplaceErrorDialog_6;
                            HotCodeReplaceErrorDialog.this.target.disconnect();
                        } else {
                            this.val$operation[0] = DebugUIMessages.HotCodeReplaceErrorDialog_8;
                            ILaunch launch = HotCodeReplaceErrorDialog.this.target.getLaunch();
                            launch.terminate();
                            ILaunchConfiguration config = launch.getLaunchConfiguration();
                            if (config != null && config.exists()) {
                                DebugUITools.launch((ILaunchConfiguration)config, (String)launch.getLaunchMode());
                            }
                        }
                    }
                    catch (DebugException e) {
                        this.val$ex[0] = e;
                    }
                }
            };
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
            if (ex[0] != null) {
                JDIDebugUIPlugin.statusDialog(NLS.bind((String)DebugUIMessages.HotCodeReplaceErrorDialog_2, (Object[])operation), ex[0].getStatus());
            }
            this.okPressed();
        } else {
            super.buttonPressed(id, this.target);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            JDIDebugTarget debugTarget;
            Object object;
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && (object = event.getSource()) instanceof JDIDebugTarget && this.target == (debugTarget = (JDIDebugTarget)object)) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> ((HotCodeReplaceErrorDialog)this).close());
                return;
            }
            ++n2;
        }
    }
}

