/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.html.HtmlLanguageBuilder;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HtmlParser;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlLanguage
extends MarkupLanguage {
    static final String NAME_HTML = "HTML";
    private boolean parseCleansHtml = true;

    public HtmlLanguage() {
        this.setName(NAME_HTML);
    }

    public boolean isParseCleansHtml() {
        return this.parseCleansHtml;
    }

    public void setParseCleansHtml(boolean parseCleansHtml) {
        this.parseCleansHtml = parseCleansHtml;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        HtmlParser htmlParser = this.createHtmlParser();
        InputSource source = new InputSource(new StringReader(markupContent));
        try {
            htmlParser.parse(source, parser.getBuilder(), asDocument);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    HtmlParser createHtmlParser() {
        return this.parseCleansHtml ? HtmlParser.instanceWithHtmlCleanupRules() : new HtmlParser();
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        return new HtmlDocumentBuilder(out, formatting);
    }

    public static HtmlLanguageBuilder builder() {
        return new HtmlLanguageBuilder();
    }

    public HtmlLanguage clone() {
        HtmlLanguage copy = (HtmlLanguage)super.clone();
        copy.setParseCleansHtml(this.parseCleansHtml);
        return copy;
    }
}

