/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.TableColumnDescriptor;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentSizeFormatter;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;

public class AttachmentTableLabelProvider
extends StyledCellLabelProvider {
    private final AttachmentSizeFormatter sizeFormatter = AttachmentSizeFormatter.getInstance();
    private final CommonImageManger imageManager = new CommonImageManger();

    public void update(ViewerCell cell) {
        cell.setImage(this.getColumnImage(cell.getElement(), cell.getColumnIndex()));
        StyledString str = this.buildTextFromEventIndex(cell.getColumnIndex(), (ITaskAttachment)cell.getElement());
        cell.setText(str.getString());
        cell.setStyleRanges(str.getStyleRanges());
        super.update(cell);
    }

    protected void measure(Event event, Object element) {
        super.measure(event, element);
        this.measure4MulitlineColumn(event, element);
    }

    protected void measure4MulitlineColumn(Event event, Object element) {
        ColumnViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableColumn col = ((TableViewer)viewer).getTable().getColumn(event.index);
            TableColumnDescriptor colDes = (TableColumnDescriptor)col.getData("org.eclipse.mylyn.commons.ui.TableColumnDescriptors");
            if (colDes != null && !colDes.isAutoSize()) {
                return;
            }
            event.width = ((TableViewer)viewer).getTable().getColumn(event.index).getWidth();
            if (event.width == 0) {
                return;
            }
            ITaskAttachment attachment = (ITaskAttachment)element;
            Point size = event.gc.textExtent(this.buildTextFromEventIndex(event.index, attachment).getString());
            event.height = size.y;
            size.x = event.index == 0 || event.index == 3 ? (size.x += 22) : (size.x += 3);
            if (size.x > event.width) {
                event.width = size.x;
                ((TableViewer)viewer).getTable().getColumn(event.index).setWidth(size.x);
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ITaskAttachment attachment = (ITaskAttachment)element;
        if (columnIndex == 0) {
            if (AttachmentUtil.isContext(attachment)) {
                return this.imageManager.getImage(TasksUiImages.CONTEXT_TRANSFER);
            }
            if (attachment.isPatch()) {
                return this.imageManager.getImage(TasksUiImages.TASK_ATTACHMENT_PATCH);
            }
            return this.imageManager.getFileImage(attachment.getFileName());
        }
        if (columnIndex == 3 && attachment.getAuthor() != null) {
            return this.getAuthorImage(attachment.getAuthor(), attachment.getTaskRepository());
        }
        return null;
    }

    protected Image getAuthorImage(IRepositoryPerson person, TaskRepository repository) {
        if (repository != null && person != null && person.matchesUsername(repository.getUserName())) {
            return this.imageManager.getImage(CommonImages.PERSON_ME);
        }
        return this.imageManager.getImage(CommonImages.PERSON);
    }

    public StyledString buildTextFromEventIndex(int index, ITaskAttachment attachment) {
        StyledString text = new StyledString();
        switch (index) {
            case 0: {
                if (AttachmentUtil.isContext(attachment)) {
                    text.append(Messages.AttachmentTableLabelProvider_Task_Context);
                    break;
                }
                if (attachment.isPatch()) {
                    text.append(Messages.AttachmentTableLabelProvider_Patch);
                    break;
                }
                text.append(" " + attachment.getFileName());
                break;
            }
            case 1: {
                if (attachment.getDescription() == null) break;
                text.append(attachment.getDescription());
                break;
            }
            case 2: {
                long length = attachment.getLength();
                if (length < 0L) {
                    text.append("-");
                }
                text.append(this.sizeFormatter.format(length));
                break;
            }
            case 3: {
                String autherText = attachment.getAuthor() != null ? attachment.getAuthor().toString() : "";
                String[] autherPart = autherText.split(" <");
                text.append(autherPart[0] + " ", StyledString.COUNTER_STYLER);
                if (autherPart.length <= 1) break;
                text.append("<" + autherPart[1], StyledString.COUNTER_STYLER);
                break;
            }
            case 4: {
                text.append(attachment.getCreationDate() != null ? EditorUtil.formatDateTime(attachment.getCreationDate()) : "");
                break;
            }
            case 5: {
                text.append(AttachmentTableLabelProvider.getAttachmentId(attachment));
            }
        }
        return text;
    }

    public static String getAttachmentId(ITaskAttachment attachment) {
        int i;
        String a = attachment.getUrl();
        if (a != null && (i = a.indexOf("?id=")) != -1) {
            return a.substring(i + 4);
        }
        return "";
    }
}

