/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.core.auth;

import java.util.Objects;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;

public class OpenIdCredentials
extends AuthenticationCredentials {
    private final String responseUrl;
    private final String token;

    public OpenIdCredentials(String responseUrl, String token) {
        this.responseUrl = responseUrl;
        this.token = token;
    }

    protected OpenIdCredentials(ICredentialsStore store, String prefix, boolean loadSecrets) {
        this(store.get(prefix + ".responseUrl", null), store.get(prefix + ".token", null));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OpenIdCredentials other = (OpenIdCredentials)obj;
        if (!Objects.equals(this.responseUrl, other.responseUrl)) {
            return false;
        }
        return Objects.equals(this.token, other.token);
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    public String getToken() {
        return this.token;
    }

    public int hashCode() {
        return Objects.hash(this.responseUrl, this.token);
    }

    @Override
    public void clear(ICredentialsStore store, String prefix) {
        store.remove(prefix + ".responseUrl");
        store.remove(prefix + ".token");
    }

    @Override
    public void save(ICredentialsStore store, String prefix) {
        store.put(prefix + ".responseUrl", this.responseUrl, true);
        store.put(prefix + ".token", this.token, true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OpenIdCredentials [responseUrl=");
        builder.append(this.responseUrl);
        builder.append(", token=");
        builder.append(this.token);
        builder.append("]");
        return builder.toString();
    }
}

