/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.filepath.IFilePathExpression;
import org.eclipse.lemminx.extensions.filepath.IFilePathSupportParticipant;
import org.eclipse.lemminx.extensions.filepath.settings.FilePathExpression;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.FilesUtils;

public class XSDFilePathSupportParticipant
implements IFilePathSupportParticipant {
    private static final List<IFilePathExpression> XSD_FILE_PATH_EXPRESSIONS = Arrays.asList(new XSDFilePathExpression("include/@schemaLocation"), new XSDFilePathExpression("import/@schemaLocation"));

    @Override
    public List<IFilePathExpression> collectFilePathExpressions(DOMDocument document) {
        if (!DOMUtils.isXSD(document)) {
            return Collections.emptyList();
        }
        return XSD_FILE_PATH_EXPRESSIONS;
    }

    private static class XSDFilePathExpression
    extends FilePathExpression {
        public XSDFilePathExpression(String xpath) {
            super(xpath);
        }

        @Override
        protected boolean acceptFile(Path path) {
            return DOMUtils.isXSD(FilesUtils.getFileName(path));
        }
    }
}

