/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.IDisposeListener;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.IErrorBar;
import org.eclipse.swtchart.ISeriesLabel;
import org.eclipse.swtchart.model.CartesianSeriesModel;

public interface ISeries<DataType> {
    public String getId();

    public void setVisible(boolean var1);

    public void setVisibleBuffered(boolean var1);

    public boolean isVisible();

    public boolean isVisibleBuffered();

    public SeriesType getType();

    public void enableStack(boolean var1);

    public boolean isStackEnabled();

    public void setXSeries(double[] var1);

    public void setYSeries(double[] var1);

    @Deprecated
    public void setXDateSeries(Date[] var1);

    @Deprecated
    public Date[] getXDateSeries();

    public void setXLocalDateSeries(LocalDate[] var1, ZoneOffset var2);

    public LocalDate[] getXLocalDateSeries(ZoneOffset var1);

    public double[] getXSeries();

    public double[] getYSeries();

    public void setDataModel(CartesianSeriesModel<DataType> var1);

    public CartesianSeriesModel<DataType> getDataModel();

    public int getXAxisId();

    public void setXAxisId(int var1);

    public int getYAxisId();

    public void setYAxisId(int var1);

    public IErrorBar getXErrorBar();

    public IErrorBar getYErrorBar();

    public ISeriesLabel getLabel();

    public void setVisibleInLegend(boolean var1);

    public boolean isVisibleInLegend();

    public void setDescription(String var1);

    public String getDescription();

    public Point getPixelCoordinates(int var1);

    public void addDisposeListener(IDisposeListener var1);

    public static enum SeriesType implements IEnumLabel
    {
        LINE("Line"),
        BAR("Bar"),
        PIE("Pie"),
        DOUGHNUT("Doughnut");

        private String label;

        private SeriesType(String label) {
            this.label = label;
        }

        @Override
        public String label() {
            return this.label;
        }
    }
}

