/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.CWordIterator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;

public class TextFieldNavigationHandler {
    public static void install(Text text) {
        new FocusHandler(new TextNavigable(text));
    }

    public static void install(StyledText styledText) {
        new FocusHandler(new StyledTextNavigable(styledText));
    }

    public static void install(Combo combo) {
        new FocusHandler(new ComboNavigable(combo));
    }

    private static class ComboNavigable
    extends WorkaroundNavigable {
        private final Combo fCombo;

        public ComboNavigable(Combo combo) {
            this.fCombo = combo;
            this.fLastSelection = this.getSelection();
            this.fCaretPosition = this.fLastSelection.y;
            this.fCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    this.selectionChanged();
                }
            });
            this.fCombo.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    this.selectionChanged();
                }
            });
        }

        @Override
        public Control getControl() {
            return this.fCombo;
        }

        @Override
        public String getText() {
            return this.fCombo.getText();
        }

        @Override
        public void setText(String text) {
            this.fCombo.setText(text);
        }

        @Override
        public Point getSelection() {
            return this.fCombo.getSelection();
        }

        @Override
        public int getCaretPosition() {
            this.selectionChanged();
            return this.fCaretPosition;
        }

        @Override
        public void setSelection(int start, int end) {
            this.fCombo.setSelection(new Point(start, end));
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private static final String EMPTY_TEXT = "";
        private final CWordIterator fIterator = new CWordIterator();
        private final Navigable fNavigable;
        private KeyAdapter fKeyListener;

        private FocusHandler(Navigable navigable) {
            this.fNavigable = navigable;
            Control control = navigable.getControl();
            control.addFocusListener((FocusListener)this);
            if (control.isFocusControl()) {
                this.activate();
            }
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    this.deactivate();
                }
            });
        }

        public void focusGained(FocusEvent e) {
            this.activate();
        }

        public void focusLost(FocusEvent e) {
            this.deactivate();
        }

        private void activate() {
            this.fNavigable.getControl().addKeyListener((KeyListener)this.getKeyListener());
        }

        private void deactivate() {
            if (this.fKeyListener != null) {
                Control control = this.fNavigable.getControl();
                if (!control.isDisposed()) {
                    control.removeKeyListener((KeyListener)this.fKeyListener);
                }
                this.fKeyListener = null;
            }
        }

        private KeyAdapter getKeyListener() {
            if (this.fKeyListener == null) {
                this.fKeyListener = new KeyAdapter(){
                    private final boolean IS_WORKAROUND;
                    private List<Submission> fSubmissions;
                    {
                        this.IS_WORKAROUND = focusHandler.fNavigable instanceof ComboNavigable || focusHandler.fNavigable instanceof TextNavigable && TextNavigable.BUG_106024_TEXT_SELECTION;
                    }

                    public void keyPressed(KeyEvent e) {
                        if (this.IS_WORKAROUND) {
                            if (e.keyCode == 0x1000003 && e.stateMask == SWT.MOD2) {
                                int caretPosition = fNavigable.getCaretPosition();
                                if (caretPosition != 0) {
                                    Point selection = fNavigable.getSelection();
                                    if (caretPosition == selection.x) {
                                        fNavigable.setSelection(selection.y, caretPosition - 1);
                                    } else {
                                        fNavigable.setSelection(selection.x, caretPosition - 1);
                                    }
                                }
                                e.doit = false;
                                return;
                            }
                            if (e.keyCode == 0x1000004 && e.stateMask == SWT.MOD2) {
                                String text = fNavigable.getText();
                                int caretPosition = fNavigable.getCaretPosition();
                                if (caretPosition != text.length()) {
                                    Point selection = fNavigable.getSelection();
                                    if (caretPosition == selection.y) {
                                        fNavigable.setSelection(selection.x, caretPosition + 1);
                                    } else {
                                        fNavigable.setSelection(selection.y, caretPosition + 1);
                                    }
                                }
                                e.doit = false;
                                return;
                            }
                        }
                        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                        KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                        for (Submission submission : this.getSubmissions()) {
                            TriggerSequence[] triggerSequences = submission.getTriggerSequences();
                            int i = 0;
                            while (i < triggerSequences.length) {
                                if (triggerSequences[i].equals((Object)keySequence)) {
                                    e.doit = false;
                                    submission.execute();
                                    return;
                                }
                                ++i;
                            }
                        }
                    }

                    private List<Submission> getSubmissions() {
                        if (this.fSubmissions != null) {
                            return this.fSubmissions;
                        }
                        this.fSubmissions = new ArrayList<Submission>();
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
                        if (commandService == null || bindingService == null) {
                            return this.fSubmissions;
                        }
                        BindingManager localBindingManager = new BindingManager(new ContextManager(), new CommandManager());
                        Scheme[] definedSchemes = bindingService.getDefinedSchemes();
                        if (definedSchemes != null) {
                            try {
                                int i = 0;
                                while (i < definedSchemes.length) {
                                    Scheme scheme = definedSchemes[i];
                                    Scheme localSchemeCopy = localBindingManager.getScheme(scheme.getId());
                                    localSchemeCopy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                                    ++i;
                                }
                            }
                            catch (NotDefinedException e) {
                                CUIPlugin.log(e);
                            }
                        }
                        localBindingManager.setLocale(bindingService.getLocale());
                        localBindingManager.setPlatform(bindingService.getPlatform());
                        localBindingManager.setBindings(bindingService.getBindings());
                        try {
                            Scheme activeScheme = bindingService.getActiveScheme();
                            if (activeScheme != null) {
                                localBindingManager.setActiveScheme(activeScheme);
                            }
                        }
                        catch (NotDefinedException e) {
                            CUIPlugin.log(e);
                        }
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.select.wordNext")){

                            @Override
                            public void execute() {
                                fIterator.setText(fNavigable.getText());
                                int caretPosition = fNavigable.getCaretPosition();
                                int newCaret = fIterator.following(caretPosition);
                                if (newCaret != -1) {
                                    Point selection = fNavigable.getSelection();
                                    if (caretPosition == selection.y) {
                                        fNavigable.setSelection(selection.x, newCaret);
                                    } else {
                                        fNavigable.setSelection(selection.y, newCaret);
                                    }
                                }
                                fIterator.setText(FocusHandler.EMPTY_TEXT);
                            }
                        });
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.select.wordPrevious")){

                            @Override
                            public void execute() {
                                fIterator.setText(fNavigable.getText());
                                int caretPosition = fNavigable.getCaretPosition();
                                int newCaret = fIterator.preceding(caretPosition);
                                if (newCaret != -1) {
                                    Point selection = fNavigable.getSelection();
                                    if (caretPosition == selection.x) {
                                        fNavigable.setSelection(selection.y, newCaret);
                                    } else {
                                        fNavigable.setSelection(selection.x, newCaret);
                                    }
                                }
                                fIterator.setText(FocusHandler.EMPTY_TEXT);
                            }
                        });
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.goto.wordNext")){

                            @Override
                            public void execute() {
                                fIterator.setText(fNavigable.getText());
                                int caretPosition = fNavigable.getCaretPosition();
                                int newCaret = fIterator.following(caretPosition);
                                if (newCaret != -1) {
                                    fNavigable.setSelection(newCaret, newCaret);
                                }
                                fIterator.setText(FocusHandler.EMPTY_TEXT);
                            }
                        });
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.goto.wordPrevious")){

                            @Override
                            public void execute() {
                                fIterator.setText(fNavigable.getText());
                                int caretPosition = fNavigable.getCaretPosition();
                                int newCaret = fIterator.preceding(caretPosition);
                                if (newCaret != -1) {
                                    fNavigable.setSelection(newCaret, newCaret);
                                }
                                fIterator.setText(FocusHandler.EMPTY_TEXT);
                            }
                        });
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.deleteNextWord")){

                            @Override
                            public void execute() {
                                int end;
                                int start;
                                Point selection = fNavigable.getSelection();
                                String text = fNavigable.getText();
                                if (selection.x != selection.y) {
                                    start = selection.x;
                                    end = selection.y;
                                } else {
                                    fIterator.setText(text);
                                    start = fNavigable.getCaretPosition();
                                    end = fIterator.following(start);
                                    fIterator.setText(FocusHandler.EMPTY_TEXT);
                                    if (end == -1) {
                                        return;
                                    }
                                }
                                fNavigable.setText(text.substring(0, start) + text.substring(end));
                                fNavigable.setSelection(start, start);
                            }
                        });
                        this.fSubmissions.add(new Submission(this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.deletePreviousWord")){

                            @Override
                            public void execute() {
                                int end;
                                int start;
                                Point selection = fNavigable.getSelection();
                                String text = fNavigable.getText();
                                if (selection.x != selection.y) {
                                    start = selection.x;
                                    end = selection.y;
                                } else {
                                    fIterator.setText(text);
                                    end = fNavigable.getCaretPosition();
                                    start = fIterator.preceding(end);
                                    fIterator.setText(FocusHandler.EMPTY_TEXT);
                                    if (start == -1) {
                                        return;
                                    }
                                }
                                fNavigable.setText(text.substring(0, start) + text.substring(end));
                                fNavigable.setSelection(start, start);
                            }
                        });
                        return this.fSubmissions;
                    }

                    private TriggerSequence[] getKeyBindings(BindingManager localBindingManager, ICommandService commandService, String commandID) {
                        Command command = commandService.getCommand(commandID);
                        ParameterizedCommand pCmd = new ParameterizedCommand(command, null);
                        return localBindingManager.getActiveBindingsDisregardingContextFor(pCmd);
                    }
                };
            }
            return this.fKeyListener;
        }
    }

    private static abstract class Navigable {
        private Navigable() {
        }

        public abstract Control getControl();

        public abstract String getText();

        public abstract void setText(String var1);

        public abstract Point getSelection();

        public abstract void setSelection(int var1, int var2);

        public abstract int getCaretPosition();
    }

    private static class StyledTextNavigable
    extends Navigable {
        private final StyledText fStyledText;

        public StyledTextNavigable(StyledText styledText) {
            this.fStyledText = styledText;
        }

        @Override
        public Control getControl() {
            return this.fStyledText;
        }

        @Override
        public String getText() {
            return this.fStyledText.getText();
        }

        @Override
        public void setText(String text) {
            this.fStyledText.setText(text);
        }

        @Override
        public Point getSelection() {
            return this.fStyledText.getSelection();
        }

        @Override
        public int getCaretPosition() {
            return this.fStyledText.getCaretOffset();
        }

        @Override
        public void setSelection(int start, int end) {
            this.fStyledText.setSelection(start, end);
        }
    }

    private static abstract class Submission {
        private TriggerSequence[] fTriggerSequences;

        public Submission(TriggerSequence[] triggerSequences) {
            this.fTriggerSequences = triggerSequences;
        }

        public TriggerSequence[] getTriggerSequences() {
            return this.fTriggerSequences;
        }

        public abstract void execute();
    }

    private static class TextNavigable
    extends WorkaroundNavigable {
        static final boolean BUG_106024_TEXT_SELECTION = "win32".equals(SWT.getPlatform()) || Util.isMac();
        private final Text fText;

        public TextNavigable(Text text) {
            this.fText = text;
            if (BUG_106024_TEXT_SELECTION) {
                this.fLastSelection = this.getSelection();
                this.fCaretPosition = this.fLastSelection.y;
                this.fText.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        this.selectionChanged();
                    }
                });
                this.fText.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        this.selectionChanged();
                    }
                });
            }
        }

        @Override
        public Control getControl() {
            return this.fText;
        }

        @Override
        public String getText() {
            return this.fText.getText();
        }

        @Override
        public void setText(String text) {
            this.fText.setText(text);
        }

        @Override
        public Point getSelection() {
            return this.fText.getSelection();
        }

        @Override
        public int getCaretPosition() {
            if (BUG_106024_TEXT_SELECTION) {
                this.selectionChanged();
                return this.fCaretPosition;
            }
            return this.fText.getCaretPosition();
        }

        @Override
        public void setSelection(int start, int end) {
            this.fText.setSelection(start, end);
        }
    }

    private static abstract class WorkaroundNavigable
    extends Navigable {
        Point fLastSelection;
        int fCaretPosition;

        private WorkaroundNavigable() {
        }

        void selectionChanged() {
            Point selection = this.getSelection();
            if (!selection.equals((Object)this.fLastSelection)) {
                this.fCaretPosition = selection.x == selection.y ? selection.x : (this.fLastSelection.y == selection.y ? selection.x : selection.y);
            }
            this.fLastSelection = selection;
        }
    }
}

