/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleView;

public class ConsoleViewConsoleFactory
implements IConsoleFactory {
    int counter = 1;
    private ConsoleView currentConsoleView;

    @Override
    public void openConsole() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        boolean shouldPin = this.handleAutoPin();
        try {
            String secondaryId = "Console View #" + this.counter;
            IViewPart view = page.showView("org.eclipse.ui.console.ConsoleView", secondaryId, 1);
            if (view instanceof ConsoleView) {
                ConsoleView newConsoleView = (ConsoleView)view;
                newConsoleView.setPinned(shouldPin);
            }
            ++this.counter;
        }
        catch (PartInitException e) {
            ConsolePlugin.log(e);
        }
    }

    private boolean handleAutoPin() {
        if (this.currentConsoleView == null) {
            return false;
        }
        IPreferenceStore store = ConsolePlugin.getDefault().getPreferenceStore();
        if (!store.getBoolean(IConsoleConstants.REMEMBER_AUTO_PIN_DECISION_PREF_NAME)) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)ConsoleMessages.TurnOnAutoPinDialogTitle, (String)ConsoleMessages.TurnOnAutoPinDialogMessage, (String)ConsoleMessages.TurnOnAutoPinRememberDecision, (boolean)false, null, null);
            store.setValue(IConsoleConstants.AUTO_PIN_ENABLED_PREF_NAME, toggleDialog.getReturnCode() == 0);
            store.setValue(IConsoleConstants.REMEMBER_AUTO_PIN_DECISION_PREF_NAME, toggleDialog.getToggleState());
        }
        if (store.getBoolean(IConsoleConstants.AUTO_PIN_ENABLED_PREF_NAME)) {
            this.currentConsoleView.setPinned(true);
            return true;
        }
        return false;
    }

    void setConsoleView(ConsoleView consoleView) {
        this.currentConsoleView = consoleView;
    }
}

