/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpDateGenerator;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private final boolean alwaysReplace;
    public static final ResponseDate INSTANCE = new ResponseDate();

    public ResponseDate() {
        this(false);
    }

    public ResponseDate(boolean alwaysReplace) {
        this.alwaysReplace = alwaysReplace;
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (this.alwaysReplace || response.getFirstHeader("Date") == null) {
            response.setHeader("Date", HttpDateGenerator.INSTANCE.getCurrentDate());
        }
    }
}

