/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CopyArchiveIntoProjectOperation
extends J2EEUtilityJarImportAssistantOperation {
    public CopyArchiveIntoProjectOperation(File utilityJar) {
        super(NLS.bind((String)EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Copying_archive_into_selected_proje_, (Object)utilityJar.getName()), utilityJar);
    }

    /*
     * Loose catch block
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, NLS.bind((String)EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Copying_archive_into_selected_proje_, (Object)this.getUtilityJar().getName()), null);
        try {
            IFile copiedJarFile = null;
            IProject associatedEARProject = this.getWorkspaceRoot().getProject(this.getAssociatedEARProjectName());
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)associatedEARProject);
            IContainer underlyingFolder = earComponent.getRootFolder().getUnderlyingFolder();
            String uriMapping = this.getUtilityJar().getName();
            String earLib = EarUtilities.getEARLibDir(earComponent);
            IFolder libDirFolder = null;
            if (earLib != null && earLib.length() > 0) {
                uriMapping = new Path(earLib).append(uriMapping).toString();
                libDirFolder = underlyingFolder.isAccessible() ? this.getWorkspaceRoot().getFolder(underlyingFolder.getFullPath().append(earLib)) : this.getWorkspaceRoot().getFolder(associatedEARProject.getFullPath().append(earLib));
            }
            if ((copiedJarFile = underlyingFolder.isAccessible() ? underlyingFolder.getFile((IPath)new Path(uriMapping)) : associatedEARProject.getFile(uriMapping)).exists()) {
                if (this.isOverwriteIfNecessary()) {
                    copiedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    status.add(J2EEPlugin.createErrorStatus(0, NLS.bind((String)EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Found_existing_file_0_, (Object)copiedJarFile), null));
                    return status;
                }
            }
            if (!(libDirFolder == null || libDirFolder.exists() && libDirFolder.isAccessible())) {
                CopyArchiveIntoProjectOperation.mkdirs(libDirFolder);
            }
            FileInputStream fileInputStream = null;
            ByteArrayOutputStream bos = null;
            ByteArrayInputStream jarFileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(this.getUtilityJar());
                    bos = new ByteArrayOutputStream();
                    byte[] data = new byte[4096];
                    try {
                        int bytesRead = 0;
                        while ((bytesRead = fileInputStream.read(data)) > 0) {
                            bos.write(data, 0, bytesRead);
                        }
                        data = null;
                    }
                    finally {
                        fileInputStream.close();
                    }
                    jarFileInputStream = new ByteArrayInputStream(bos.toByteArray());
                    copiedJarFile.create((InputStream)jarFileInputStream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.addLibraryToClasspath(associatedEARProject, copiedJarFile, monitor);
                    this.createVirtualArchiveComponent(associatedEARProject, uriMapping, copiedJarFile, monitor);
                }
                catch (FileNotFoundException e) {
                    status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                    J2EEPlugin.logError(0, e.getMessage(), e);
                    if (bos != null) {
                        bos.close();
                    }
                    if (jarFileInputStream != null) {
                        jarFileInputStream.close();
                    }
                }
                catch (InvocationTargetException e) {
                    block29: {
                        status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                        J2EEPlugin.logError(0, e.getMessage(), e);
                        if (bos == null) break block29;
                        bos.close();
                    }
                    if (jarFileInputStream != null) {
                        jarFileInputStream.close();
                    }
                }
                catch (InterruptedException e) {
                    block30: {
                        status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                        J2EEPlugin.logError(0, e.getMessage(), e);
                        if (bos == null) break block30;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        bos.close();
                    }
                    if (jarFileInputStream != null) {
                        jarFileInputStream.close();
                    }
                }
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (jarFileInputStream != null) {
                    jarFileInputStream.close();
                }
            }
        }
        catch (IOException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        catch (CoreException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }
}

