/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.xml;

import java.net.URL;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.xml.XMLDocumentCache;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;

public abstract class XMLDocumentCacheUser {
    protected Document getDocument(String key) {
        return (Document)XMLDocumentCache.instance().get(key);
    }

    protected void setDocument(String key, Object document) {
        XMLDocumentCache.instance().put(key, document);
    }

    public XMLDocumentCache getDocumentList() {
        return XMLDocumentCache.instance();
    }

    public Document parseXMLDocumentURL(String urlString, String baseURI) throws WSIException {
        return this.parseXMLDocumentURL(urlString, baseURI, null);
    }

    public Document parseXMLDocumentURL(String urlString, String baseURI, String schema) throws WSIException {
        Document document = null;
        try {
            URL url = XMLUtils.createURL(urlString, baseURI);
            document = this.getDocument(urlString);
            if (document == null) {
                document = XMLUtils.parseXMLDocumentURL(url, schema);
                this.setDocument(urlString, document);
            }
        }
        catch (WSIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSIException(e.getMessage(), e);
        }
        return document;
    }
}

