/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.ui.preferences.AbstractRuntimeInstallPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.StandardRuntimeInstallPage;

public abstract class RuntimeInstallWizard
extends Wizard {
    private IJSRuntimeType fRuntimeType;
    private JSRuntimeWorkingCopy fEditRuntime;
    private String[] fExistingNames;

    public RuntimeInstallWizard(JSRuntimeWorkingCopy editRuntime, IJSRuntimeType runtimeType, IJSRuntimeInstall[] currentInstalls) {
        this.fEditRuntime = editRuntime;
        this.fRuntimeType = runtimeType;
        ArrayList<String> names = new ArrayList<String>(currentInstalls.length);
        int i = 0;
        while (i < currentInstalls.length) {
            IJSRuntimeInstall install = currentInstalls[i];
            if (!install.equals(editRuntime)) {
                names.add(install.getName());
            }
            ++i;
        }
        this.fExistingNames = names.toArray(new String[names.size()]);
    }

    protected JSRuntimeWorkingCopy getRuntimeInstall() {
        return this.fEditRuntime;
    }

    protected abstract JSRuntimeWorkingCopy getResult();

    public boolean performFinish() {
        return this.getResult() != null;
    }

    public AbstractRuntimeInstallPage getPage() {
        StandardRuntimeInstallPage standardVMPage = new StandardRuntimeInstallPage();
        standardVMPage.setExistingNames(this.fExistingNames);
        return standardVMPage;
    }

    public IJSRuntimeType getRuntimeType() {
        return this.fRuntimeType;
    }
}

