/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PanelGroupLayoutOperation
extends AbstractTrinidadTransformOperation {
    private static final int LAYOUT_DEFAULT = 0;
    private static final int LAYOUT_HORIZONTAL = 1;
    private static final int LAYOUT_VERTICAL = 2;

    public Element transform(Element srcElement, Element curElement) {
        String inlineStyle;
        Element outerElement;
        int layout = this.getLayout(srcElement);
        Element containerElement = switch (layout) {
            case 1 -> {
                outerElement = this.createElement("table");
                outerElement.setAttribute("cellpadding", "0");
                outerElement.setAttribute("cellspacing", "0");
                outerElement.setAttribute("border", "0");
                yield this.appendChildElement("tr", outerElement);
            }
            case 2 -> outerElement = this.createElement("div");
            default -> outerElement = this.createElement("span");
        };
        String styleClass = srcElement.getAttribute("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            outerElement.setAttribute("class", styleClass);
        }
        if ((inlineStyle = srcElement.getAttribute("inlineStyle")) != null && inlineStyle.length() > 0) {
            outerElement.setAttribute("style", inlineStyle);
        }
        ArrayList<Node> childNodes = new ArrayList<Node>();
        for (Node copyChildrenNode : this.getCopyChildrenNodes(srcElement)) {
            if (copyChildrenNode instanceof Element && TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)copyChildrenNode)).isSameTagType(IJSFConstants.TAG_IDENTIFIER_FACET) || copyChildrenNode instanceof Text && copyChildrenNode.getNodeValue().trim().length() < 1) continue;
            childNodes.add(copyChildrenNode);
        }
        Element separatorElement = null;
        Element facetElement = this.getChildFacetByName(srcElement, "separator");
        if (facetElement != null) {
            NodeList facetChildNodes = facetElement.getChildNodes();
            int i = 0;
            while (i < facetChildNodes.getLength()) {
                Node curChildNode = facetChildNodes.item(i);
                if (curChildNode instanceof Element) {
                    separatorElement = (Element)curChildNode;
                    break;
                }
                ++i;
            }
        }
        int curChildNodeIndex = 0;
        int curIndex = 0;
        Iterator itChildNodes = childNodes.iterator();
        switch (layout) {
            case 1: {
                while (itChildNodes.hasNext()) {
                    Element childTDElement = this.appendChildElement("td", containerElement);
                    this.tagConverterContext.addChild((Node)itChildNodes.next(), new ConvertPosition((Node)childTDElement, 0));
                    if (++curChildNodeIndex >= childNodes.size() || separatorElement == null) continue;
                    Element sepTDElement = this.appendChildElement("td", containerElement);
                    this.tagConverterContext.addChild((Node)separatorElement, new ConvertPosition((Node)sepTDElement, 0));
                }
                break;
            }
            case 2: {
                while (itChildNodes.hasNext()) {
                    this.tagConverterContext.addChild((Node)itChildNodes.next(), new ConvertPosition((Node)containerElement, curIndex++));
                    if (++curChildNodeIndex >= childNodes.size()) continue;
                    Element divElement = this.appendChildElement("div", containerElement);
                    ++curIndex;
                    if (separatorElement == null) continue;
                    this.tagConverterContext.addChild((Node)separatorElement, new ConvertPosition((Node)divElement, 0));
                }
                break;
            }
            default: {
                while (itChildNodes.hasNext()) {
                    this.tagConverterContext.addChild((Node)itChildNodes.next(), new ConvertPosition((Node)containerElement, curIndex++));
                    if (++curChildNodeIndex >= childNodes.size() || separatorElement == null) continue;
                    this.tagConverterContext.addChild((Node)separatorElement, new ConvertPosition((Node)containerElement, curIndex++));
                }
                break block4;
            }
        }
        return outerElement;
    }

    private int getLayout(Element srcElement) {
        String layoutValue;
        int layout = 0;
        if (srcElement != null && (layoutValue = srcElement.getAttribute("layout")) != null) {
            if (layoutValue.equals("horizontal")) {
                layout = 1;
            } else if (layoutValue.equals("vertical")) {
                layout = 2;
            }
        }
        return layout;
    }
}

