/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLinkBendpoint;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;

public class PageflowLayoutManager {
    private static final int NODE_DEFAULT_WIDTH = 50;
    private static final int NODE_DEFAULT_HEIGHT = 50;
    private static final int X_SPACE = 50;
    private static final int Y_SPACE = 50;
    private static final int DEFAULT_PADDING = 30;
    private static PageflowLayoutManager manager;
    private Map copiedLinks = null;

    private PageflowLayoutManager() {
    }

    public static PageflowLayoutManager getInstance() {
        if (manager == null) {
            manager = new PageflowLayoutManager();
        }
        return manager;
    }

    public void layoutPageflow(Pageflow pageflow) {
        List selfLoopLinks = this.removeSelfLoopLinks(pageflow);
        List lstGraph = this.createGraphs(pageflow);
        for (DirectedGraph graph : lstGraph) {
            new DirectedGraphLayout().visit(graph);
        }
        this.updatePageflow(lstGraph);
        if (selfLoopLinks != null) {
            this.addSelfLoopLinks(pageflow, selfLoopLinks);
        }
    }

    private List removeSelfLoopLinks(Pageflow pageflow) {
        ArrayList<PageflowLink> selfLoopLinks = new ArrayList<PageflowLink>();
        if (pageflow.getLinks() != null) {
            Iterator iter = pageflow.getLinks().iterator();
            while (iter.hasNext()) {
                PageflowLink link = (PageflowLink)iter.next();
                if (link.getSource() != link.getTarget()) continue;
                iter.remove();
                link.getBendPoints().clear();
                selfLoopLinks.add(link);
            }
        }
        return selfLoopLinks;
    }

    private void addSelfLoopLinks(Pageflow pageflow, List selfLoopLinks) {
        if (pageflow.getLinks() != null && selfLoopLinks != null && selfLoopLinks.size() > 0) {
            EList links = pageflow.getLinks();
            for (PageflowLink link : selfLoopLinks) {
                PageflowLayoutManager.updateSelfLoopLink(link);
                links.add((Object)link);
            }
        }
    }

    public static void updateSelfLoopLink(PageflowLink selfLoopLink) {
        PageflowNode sourceNode = selfLoopLink.getSource();
        Rectangle rectNode = PageflowLayoutManager.getPageflowNodeBounds(sourceNode);
        EList outLinks = sourceNode.getOutlinks();
        if (outLinks != null && outLinks.size() > 0) {
            for (PageflowLink anotherSelfLoopLink : outLinks) {
                if (anotherSelfLoopLink == selfLoopLink || anotherSelfLoopLink.getTarget() != sourceNode) continue;
                rectNode = PageflowLayoutManager.getFitnessRectangle(rectNode, anotherSelfLoopLink);
            }
        }
        PageflowFactory factory = PageflowModelManager.getFactory();
        PageflowLinkBendpoint bpTop = factory.createPFLinkBendpoint();
        PageflowLinkBendpoint bpLeftTop = factory.createPFLinkBendpoint();
        PageflowLinkBendpoint bpLeft = factory.createPFLinkBendpoint();
        bpTop.setD1Height(-rectNode.height);
        bpTop.setD2Height(-rectNode.height);
        bpLeftTop.setD1Width(-rectNode.width);
        bpLeftTop.setD1Height(-rectNode.height);
        bpLeftTop.setD2Width(-rectNode.width);
        bpLeftTop.setD2Height(-rectNode.height);
        bpLeft.setD1Width(-rectNode.width);
        bpLeft.setD2Width(-rectNode.width);
        selfLoopLink.getBendPoints().add((Object)bpTop);
        selfLoopLink.getBendPoints().add((Object)bpLeftTop);
        selfLoopLink.getBendPoints().add((Object)bpLeft);
    }

    private static Rectangle getFitnessRectangle(Rectangle rectDefault, PageflowLink anotherSelfLoopLink) {
        EList bendPoints = anotherSelfLoopLink.getBendPoints();
        if (bendPoints != null && bendPoints.size() > 0) {
            for (PageflowLinkBendpoint bendPoint : bendPoints) {
                if (bendPoint.getD1Width() != -rectDefault.width || bendPoint.getD1Height() != -rectDefault.height) continue;
                rectDefault = new Rectangle(0, 0, rectDefault.width + 30, rectDefault.height + 30);
                break;
            }
        }
        return rectDefault;
    }

    private static Rectangle getPageflowNodeBounds(PageflowNode pfNode) {
        return new Rectangle(0, 0, 64, 36);
    }

    private static Rectangle getPageflowNodeRectangle(PageflowNode pfNode) {
        Rectangle rectNode = null;
        Rectangle bounds = PageflowLayoutManager.getPageflowNodeBounds(pfNode);
        rectNode = new Rectangle(pfNode.getX(), pfNode.getY(), bounds.width, bounds.height);
        return rectNode;
    }

    private List createGraphs(Pageflow pageflow) {
        ArrayList<DirectedGraph> lstGraph = null;
        if (pageflow != null) {
            DirectedGraph graph = null;
            HashMap<PageflowNode, Node> nodesMap = new HashMap<PageflowNode, Node>();
            NodeList nodes = new NodeList();
            EdgeList edges = new EdgeList();
            EList pfNodes = pageflow.getNodes();
            if (pfNodes != null) {
                for (PageflowNode pfNode : pfNodes) {
                    Node node = new Node((Object)pfNode);
                    Rectangle rectNode = null;
                    rectNode = PageflowLayoutManager.getPageflowNodeBounds(pfNode);
                    if (rectNode != null) {
                        node.width = rectNode.width * 2;
                        node.height = rectNode.height * 2;
                        node.setPadding(new Insets(node.height, node.width, node.height, node.width));
                    } else {
                        node.width = 50;
                        node.height = 50;
                        node.setPadding(new Insets(30));
                    }
                    nodesMap.put(pfNode, node);
                    nodes.add((Object)node);
                }
            }
            EList pfLinks = pageflow.getLinks();
            for (PageflowLink link : pfLinks) {
                PageflowNode source = link.getSource();
                PageflowNode target = link.getTarget();
                Node sourceNode = (Node)nodesMap.get(source);
                Node targetNode = (Node)nodesMap.get(target);
                if (sourceNode == null || targetNode == null) continue;
                Edge edge = new Edge(sourceNode, targetNode);
                edges.add((Object)edge);
            }
            graph = new DirectedGraph();
            graph.nodes = nodes;
            graph.edges = edges;
            lstGraph = new ArrayList<DirectedGraph>();
            lstGraph.add(graph);
        }
        return lstGraph;
    }

    private void updatePageflow(List lstGraph) {
        int topSubGraph = 0;
        Iterator iter = lstGraph.iterator();
        while (iter.hasNext()) {
            int bottomSubGraph = 0;
            DirectedGraph graph = (DirectedGraph)iter.next();
            int i = 0;
            while (i < graph.nodes.size()) {
                Node node = graph.nodes.getNode(i);
                if (node.data instanceof PageflowNode) {
                    PageflowNode pfNode = (PageflowNode)node.data;
                    pfNode.setX(50 + node.y);
                    pfNode.setY(50 + node.x + topSubGraph);
                    if (50 + node.x + topSubGraph > bottomSubGraph) {
                        bottomSubGraph = 50 + node.x + topSubGraph;
                    }
                }
                ++i;
            }
            topSubGraph = bottomSubGraph + 50;
        }
    }

    public void updatePageflowLayout(Pageflow newPageflow, Pageflow oldPageflow) {
        ArrayList<PageflowNode> notUpdatedNodes = new ArrayList<PageflowNode>();
        this.copiedLinks = new HashMap();
        if (oldPageflow.getNodes().size() > 0) {
            for (PageflowNode newNode : newPageflow.getNodes()) {
                if (this.updatePageflowNode(newNode, oldPageflow)) continue;
                notUpdatedNodes.add(newNode);
            }
        } else {
            notUpdatedNodes.addAll((Collection<PageflowNode>)newPageflow.getNodes());
        }
        if (oldPageflow.getLinks().size() > 0) {
            for (PageflowLink newLink : newPageflow.getLinks()) {
                this.updatePFLink(newLink, oldPageflow);
            }
        }
        if (notUpdatedNodes.size() > 0) {
            this.resolveConflict(newPageflow, notUpdatedNodes);
        }
    }

    private boolean updatePageflowNode(PageflowNode newNode, Pageflow oldPageflow) {
        for (PageflowNode oldNode : oldPageflow.getNodes()) {
            if (!(oldNode instanceof PageflowPage) || !(newNode instanceof PageflowPage) || !((PageflowPage)oldNode).getPath().trim().equals(((PageflowPage)newNode).getPath().trim())) continue;
            this.updatePageflowNode(newNode, oldNode);
            return true;
        }
        return false;
    }

    private void updatePageflowNode(PageflowNode newNode, PageflowNode node) {
        newNode.setX(node.getX());
        newNode.setY(node.getY());
    }

    private void resolveConflict(Pageflow newPageflow, List notUpdatedNodes) {
        Iterator iter = notUpdatedNodes.iterator();
        while (iter.hasNext()) {
            this.resolveConflict(newPageflow, (PageflowNode)iter.next());
        }
    }

    private void resolveConflict(Pageflow newPageflow, PageflowNode node) {
        Rectangle nodeRect = PageflowLayoutManager.getPageflowNodeRectangle(node);
        boolean bModified = false;
        int i = 0;
        int size = newPageflow.getNodes().size();
        while (i < size) {
            Rectangle fixedNodeRect;
            PageflowNode fixedNode = (PageflowNode)newPageflow.getNodes().get(i);
            if (node != fixedNode && (fixedNodeRect = PageflowLayoutManager.getPageflowNodeRectangle(fixedNode)).intersects(nodeRect)) {
                nodeRect.x += fixedNodeRect.width + 50;
                nodeRect.y += fixedNodeRect.height + 50;
                bModified = true;
            }
            ++i;
        }
        if (bModified) {
            node.setX(nodeRect.x);
            node.setY(nodeRect.y);
        }
    }

    private void updatePFLink(PageflowLink newLink, Pageflow oldPageflow) {
        for (PageflowLink oldLink : oldPageflow.getLinks()) {
            if (this.copiedLinks.get(oldLink) != null || !this.isSameLink(newLink, oldLink)) continue;
            this.updatePFLink(newLink, oldLink);
            break;
        }
    }

    private boolean isSameLink(PageflowLink newLink, PageflowLink oldLink) {
        PageflowNode newSource = newLink.getSource();
        PageflowNode newTarget = newLink.getTarget();
        PageflowNode oldSource = oldLink.getSource();
        PageflowNode oldTarget = oldLink.getTarget();
        return newSource instanceof PageflowPage && oldSource instanceof PageflowPage && newTarget instanceof PageflowPage && oldTarget instanceof PageflowPage && ((PageflowPage)newSource).getPath().trim().equalsIgnoreCase(((PageflowPage)oldSource).getPath().trim()) && ((PageflowPage)newTarget).getPath().trim().equalsIgnoreCase(((PageflowPage)oldTarget).getPath().trim()) && (newLink.getOutcome() == null && oldLink.getOutcome() == null || newLink.getOutcome() != null && oldLink.getOutcome() != null && newLink.getOutcome().trim().equals(oldLink.getOutcome().trim()));
    }

    private PageflowLink updatePFLink(PageflowLink newLink, PageflowLink link) {
        PageflowFactory factory = PageflowModelManager.getFactory();
        newLink.getBendPoints().clear();
        for (PageflowLinkBendpoint bendPoint : link.getBendPoints()) {
            PageflowLinkBendpoint newBendPoint = factory.createPFLinkBendpoint();
            newBendPoint.setD1Height(bendPoint.getD1Height());
            newBendPoint.setD1Width(bendPoint.getD1Width());
            newBendPoint.setD2Height(bendPoint.getD2Height());
            newBendPoint.setD2Width(bendPoint.getD2Width());
            newLink.getBendPoints().add((Object)newBendPoint);
        }
        this.copiedLinks.put(link, link);
        return newLink;
    }
}

