/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.ExpressionCommands;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMExpressionConnection;
import org.eclipse.jem.util.TimerTests;

public class REMConnection
implements IREMConnection,
IREMExpressionConnection {
    public static final String INVOKE_STEP = "Invoke";
    public static final String INVOKE_METHOD_STEP = "Invoke Method";
    protected Socket fSocket = null;
    protected DataInputStream in = null;
    protected DataOutputStream out = null;
    private static final int TIME_OUT = 60000;

    public REMConnection(Socket socket, boolean noTimeouts) {
        try {
            Integer bufSize;
            this.fSocket = socket;
            this.fSocket.setSoLinger(true, 30);
            if (!noTimeouts) {
                this.fSocket.setSoTimeout(60000);
            }
            if ((bufSize = Integer.getInteger("proxyvm.bufsize")) == null) {
                bufSize = new Integer(16000);
            }
            this.out = new DataOutputStream(new BufferedOutputStream(this.fSocket.getOutputStream(), bufSize));
            this.in = new DataInputStream(new BufferedInputStream(this.fSocket.getInputStream(), bufSize));
        }
        catch (IOException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {}
            this.fSocket = null;
            this.in = null;
            this.out = null;
        }
    }

    @Override
    public boolean isConnected() {
        return this.fSocket != null;
    }

    @Override
    public void terminateServer() {
        if (this.isConnected()) {
            try {
                Commands.sendTerminateCommand(this.out);
            }
            catch (IOException iOException) {}
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.isConnected()) {
            block24: {
                try {
                    try {
                        Commands.sendQuitCommand(this.out);
                    }
                    catch (IOException iOException) {
                        try {
                            this.out.close();
                        }
                        catch (IOException iOException2) {}
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException3) {}
                        try {
                            this.fSocket.close();
                        }
                        catch (IOException iOException4) {}
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fSocket.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fSocket.close();
                }
                catch (IOException iOException) {}
            }
            this.fSocket = null;
            this.in = null;
            this.out = null;
        }
    }

    @Override
    public Commands.GetClassReturn getClass(String className) throws CommandException {
        block3: {
            if (this.isConnected()) {
                try {
                    return Commands.sendGetClassCommand(this.out, this.in, className);
                }
                catch (CommandErrorException e) {
                    if (e.getErrorCode() == 2) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    @Override
    public Commands.GetClassIDReturn getClassFromID(int classID) throws CommandException {
        if (this.isConnected()) {
            return Commands.sendGetClassFromIDCommand(this.out, this.in, classID);
        }
        return null;
    }

    @Override
    public void getObjectData(int classID, Commands.ValueObject valueReturn) throws CommandException {
        if (this.isConnected()) {
            Commands.sendGetObjectData(this.out, this.in, classID, valueReturn);
        } else {
            valueReturn.set();
        }
    }

    @Override
    public void getNewInstance(int classID, String initString, Commands.ValueObject newInstance) throws CommandException {
        if (this.isConnected()) {
            Commands.sendNewInstance(this.out, this.in, classID, initString, newInstance);
        } else {
            newInstance.set();
        }
    }

    @Override
    public void releaseID(int id) {
        if (this.isConnected()) {
            try {
                Commands.releaseObjectCommand(this.out, id);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void getArrayContents(int arrayID, Commands.ValueObject returnValue) throws CommandException {
        if (this.isConnected()) {
            Commands.sendGetArrayContentsCommand(this.out, this.in, arrayID, returnValue);
        }
    }

    @Override
    public void invokeMethod(int methodID, Commands.ValueObject invokeOn, Commands.ValueObject parms, Commands.ValueObject returnValue) throws CommandException {
        if (this.isConnected()) {
            TimerTests.basicTest.startCumulativeStep(INVOKE_METHOD_STEP);
            Commands.sendInvokeMethodCommand(this.out, this.in, methodID, invokeOn, parms, returnValue);
            TimerTests.basicTest.stopCumulativeStep(INVOKE_METHOD_STEP);
        }
    }

    @Override
    public void invokeMethod(Commands.ValueObject classType, String methodName, Commands.ValueObject parmTypes, Commands.ValueObject invokeOn, Commands.ValueObject parms, Commands.ValueObject returnValue) throws CommandException {
        if (this.isConnected()) {
            TimerTests.basicTest.startCumulativeStep(INVOKE_STEP);
            Commands.sendInvokeMethodCommand(this.out, this.in, classType, methodName, parmTypes, invokeOn, parms, returnValue);
            TimerTests.basicTest.stopCumulativeStep(INVOKE_STEP);
        }
    }

    @Override
    public void startExpressionProcessing(int expressionID, byte trace) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendStartExpressionProcessingCommand(expressionID, trace, this.out);
        }
    }

    @Override
    public void pushExpressionCommand(int expressionID, byte subcommand) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendExpressionCommand(expressionID, this.out, subcommand);
        }
    }

    @Override
    public void stopExpressionProcessing(int expressionID) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendEndExpressionProcessingCommand(expressionID, this.out);
        }
    }

    @Override
    public void pushValueObject(Commands.ValueObject valueObject) throws CommandException {
        if (this.isConnected()) {
            Commands.writeValue(this.out, valueObject, false);
        }
    }

    @Override
    public void pushByte(byte abyte) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendByte(this.out, abyte);
        }
    }

    @Override
    public void pushInt(int anInt) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendInt(this.out, anInt);
        }
    }

    @Override
    public void pushString(String aString) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendString(this.out, aString);
        }
    }

    @Override
    public void pushBoolean(boolean aBool) throws IOException {
        if (this.isConnected()) {
            ExpressionCommands.sendBoolean(this.out, aBool);
        }
    }

    @Override
    public void getFinalValue(Commands.ValueObject result) throws CommandException {
        if (this.isConnected()) {
            Commands.readBackValue(this.in, result, (byte)-1);
        }
    }

    @Override
    public void pullValue(int expressionID, Commands.ValueObject proxyids, Commands.ValueSender sender) throws CommandException {
        if (this.isConnected()) {
            ExpressionCommands.sendPullValueCommand(expressionID, this.out, this.in, proxyids, sender);
        }
    }

    @Override
    public void sync(int expressionID, Commands.ValueObject proxyids, Commands.ValueSender sender) throws CommandException {
        if (this.isConnected()) {
            ExpressionCommands.sendSyncCommand(expressionID, this.out, this.in, proxyids, sender);
        }
    }

    @Override
    public void readProxyArrayValues(Commands.ValueObject returnValue, Commands.ValueSender valueSender, boolean allowFlag) throws CommandException {
        if (this.isConnected()) {
            Commands.readArray(this.in, returnValue.anInt, valueSender, returnValue, allowFlag);
        }
    }

    @Override
    public void transferExpression(int expressionID, Commands.ValueObject expController) throws CommandException {
        if (this.isConnected()) {
            ExpressionCommands.sendTransferExpressionCommand(expressionID, this.out, this.in, expController);
        }
    }

    @Override
    public void resumeExpression(int expressionID, Commands.ValueObject expController) throws CommandException {
        if (this.isConnected()) {
            ExpressionCommands.sendResumeExpressionCommand(expressionID, this.out, expController);
        }
    }
}

