/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsSection;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.util.ExtensionsFilterUtil;
import org.eclipse.swt.widgets.Text;

public class FilterRelatedExtensionsAction
extends Action {
    protected ExtensionsSection fSection;
    protected TreeViewer fExtensionTree;
    protected FormFilteredTree fFilteredTree;

    public FilterRelatedExtensionsAction(TreeViewer treeViewer, FormFilteredTree filteredTree, ExtensionsSection section) {
        this.setImageDescriptor(PDEPluginImages.DESC_FILTER_RELATED);
        this.setText(PDEUIMessages.Actions_filter_relatedPluginElements);
        this.setToolTipText(PDEUIMessages.FilterRelatedExtensionsAction_tooltip);
        this.fSection = section;
        this.fExtensionTree = treeViewer;
        this.fFilteredTree = filteredTree;
    }

    public void run() {
        String filterPattern = ExtensionsFilterUtil.getFilterRelatedPattern((IStructuredSelection)this.fExtensionTree.getStructuredSelection());
        Text filterControl = this.fFilteredTree.getFilterControl();
        if (filterControl != null && filterPattern.length() > 0) {
            this.fSection.setBypassFilterDelay(true);
            filterControl.setText(filterPattern);
        }
    }
}

