/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.PropertyElement;
import org.eclipse.m2e.model.edit.pom.util.PomResourceFactoryImpl;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.m2e.refactoring.ChangeCreator;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.m2e.refactoring.PomRefactoringException;
import org.eclipse.m2e.refactoring.PomVisitor;
import org.eclipse.m2e.refactoring.RefactoringModelResources;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPomRefactoring
extends Refactoring {
    private static final ILog log = Platform.getLog(AbstractPomRefactoring.class);
    protected static final String PROBLEMS_DURING_REFACTORING = Messages.AbstractPomRefactoring_error;
    protected IFile file;
    protected AdapterFactoryEditingDomain editingDomain;
    private HashMap<String, RefactoringModelResources> models;

    public AbstractPomRefactoring(IFile file) {
        this.file = file;
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public abstract PomVisitor getVisitor();

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    /*
     * Unable to fully structure code
     */
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        block25: {
            res = new CompositeChange(this.getTitle());
            projects = MavenPlugin.getMavenProjectRegistry().getProjects();
            pm.beginTask(Messages.AbstractPomRefactoring_task, projects.size());
            this.models = new HashMap<K, V>();
            try {
                for (IMavenProjectFacade projectFacade : projects) {
                    if (!this.scanAllArtifacts() && !projectFacade.getPom().equals((Object)this.file) || !projectFacade.getProject().isAccessible() || !projectFacade.getPom().isAccessible()) continue;
                    this.loadModel(projectFacade, pm);
                }
                for (IMavenProjectFacade projectFacade : projects) {
                    model = this.models.get(projectFacade.getArtifactKey().artifactId());
                    if (model == null) continue;
                    properties = new HashMap<String, RefactoringModelResources.PropertyInfo>();
                    workspaceParents = new ArrayList<RefactoringModelResources>();
                    current = model.getProject();
                    workspaceParents.add(model);
                    parentProject = this.getParentProject(projectFacade, current, pm);
                    while (parentProject != null) {
                        id = parentProject.getArtifactId();
                        parent = this.models.get(id);
                        if (parent == null) break;
                        workspaceParents.add(parent);
                        parentProject = this.getParentProject(projectFacade, parentProject, pm);
                    }
                    i = workspaceParents.size() - 1;
                    while (i >= 0) {
                        resource = (RefactoringModelResources)workspaceParents.get(i);
                        props = resource.getTmpModel().getProperties();
                        if (props != null) {
                            for (PropertyElement pair : props) {
                                pName = pair.getName();
                                info = (RefactoringModelResources.PropertyInfo)properties.get(pName);
                                if (info == null) {
                                    info = new RefactoringModelResources.PropertyInfo();
                                    properties.put(pName, info);
                                }
                                info.setPair(pair);
                                info.setResource(resource);
                            }
                        }
                        --i;
                    }
                    model.setProperties(properties);
                }
                for (String artifact : this.models.keySet()) {
                    model = this.models.get(artifact);
                    model.setCommand(this.getVisitor().applyChanges(model, pm));
                }
                for (String artifact : this.models.keySet()) {
                    model = this.models.get(artifact);
                    if (model.getProperties() == null) continue;
                    for (String pName : model.getProperties().keySet()) {
                        info = model.getProperties().get(pName);
                        if (info.getNewValue() == null) continue;
                        command = info.getResource().getCommand();
                        if (command == null) {
                            command = new CompoundCommand();
                            info.getResource().setCommand(command);
                        }
                        command.append(info.getNewValue());
                    }
                }
                for (String artifact : this.models.keySet()) {
                    model = this.models.get(artifact);
                    if (!model.getPomFile().equals((Object)this.file)) continue;
                    this.processCommand(model, res);
                    model.releaseAllResources();
                    this.models.remove(artifact);
                    break;
                }
                for (String artifact : this.models.keySet()) {
                    this.processCommand(this.models.get(artifact), res);
                }
                newName = this.getNewProjectName();
                if (newName != null) {
                    processor = new RenameJavaProjectProcessor(JavaCore.create((IProject)this.file.getProject()));
                    refactoring = new RenameRefactoring((RenameProcessor)processor);
                    processor.setNewElementName(newName);
                    tmp = new RefactoringStatus();
                    tmp.merge(refactoring.checkInitialConditions(pm));
                    if (!tmp.hasFatalError()) {
                        tmp.merge(refactoring.checkFinalConditions(pm));
                        if (!tmp.hasFatalError()) {
                            res.add(refactoring.createChange(pm));
                        }
                    }
                }
                break block25;
            }
            catch (PomRefactoringException ex) {
                var18_21 = new Change(){

                    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
                        return RefactoringStatus.createFatalErrorStatus((String)ex.getStatus().getMessage());
                    }

                    public Object getModifiedElement() {
                        return null;
                    }

                    public String getName() {
                        return ex.getStatus().getMessage();
                    }

                    public void initializeValidationData(IProgressMonitor pm) {
                    }

                    public Change perform(IProgressMonitor pm) {
                        return null;
                    }

                    public boolean isEnabled() {
                        return false;
                    }
                };
                ** for (artifact : this.models.keySet())
            }
lbl-1000:
            // 1 sources

            {
                this.models.get(artifact).releaseAllResources();
                continue;
            }
lbl93:
            // 1 sources

            RefactoringModelResources.cleanupTmpProject();
            return var18_21;
            {
                catch (Exception ex) {
                    try {
                        throw new CoreException(Status.error((String)AbstractPomRefactoring.PROBLEMS_DURING_REFACTORING, (Throwable)ex));
                    }
                    catch (Throwable var17_28) {
                        ** for (artifact : this.models.keySet())
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                this.models.get(artifact).releaseAllResources();
                continue;
            }
lbl102:
            // 1 sources

            RefactoringModelResources.cleanupTmpProject();
            throw var17_28;
        }
        for (String artifact : this.models.keySet()) {
            this.models.get(artifact).releaseAllResources();
        }
        RefactoringModelResources.cleanupTmpProject();
        return res;
    }

    protected MavenProject getParentProject(IMavenProjectFacade project, MavenProject current, IProgressMonitor monitor) throws CoreException {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        return (MavenProject)projectManager.execute(project, (c, m) -> ((MavenImpl)MavenPlugin.getMaven()).resolveParentProject(current, m), monitor);
    }

    public abstract String getTitle();

    protected RefactoringModelResources loadModel(IMavenProjectFacade projectFacade, IProgressMonitor pm) throws CoreException, IOException {
        pm.setTaskName(NLS.bind((String)Messages.AbstractPomRefactoring_loading, (Object)projectFacade.getProject().getName()));
        RefactoringModelResources current = new RefactoringModelResources(projectFacade);
        this.models.put(current.effective.getArtifactId(), current);
        pm.worked(1);
        return current;
    }

    public abstract boolean scanAllArtifacts();

    protected void processCommand(RefactoringModelResources model, CompositeChange res) throws Exception {
        CompoundCommand command = model.getCommand();
        if (command == null) {
            return;
        }
        if (command.canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)command);
            TextFileChange change = new ChangeCreator(model.getPomFile(), model.getPomBuffer().getDocument(), model.getTmpBuffer().getDocument(), this.file.getParent().getName()).createChange();
            res.add((Change)change);
        }
    }

    public String getNewProjectName() {
        return null;
    }

    public Model createModel() {
        try {
            PomResourceImpl resource = AbstractPomRefactoring.loadResource(this.file);
            return (Model)resource.getContents().get(0);
        }
        catch (CoreException ex) {
            log.error(PROBLEMS_DURING_REFACTORING, (Throwable)ex);
            return null;
        }
    }

    public static PomResourceImpl loadResource(IFile pomFile) throws CoreException {
        String path = pomFile.getFullPath().toOSString();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        try {
            Resource resource = new PomResourceFactoryImpl().createResource(uri);
            resource.load(new HashMap());
            return (PomResourceImpl)resource;
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)"Can't load model {0}", (Object)pomFile);
            log.error(msg, (Throwable)ex);
            throw new CoreException(Status.error((String)msg, (Throwable)ex));
        }
    }
}

