/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options.EclipseLinkLoggingComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class EclipseLinkLoggingComposite2_0
extends EclipseLinkLoggingComposite<EclipseLinkLogging2_0> {
    private static final String DEFAULT_PROPERTY = "categoriesDefaultLoggingLevel";

    public EclipseLinkLoggingComposite2_0(Pane<?> parent, PropertyValueModel<EclipseLinkLogging2_0> subjectModel, Composite parentComposite) {
        super(parent, subjectModel, parentComposite);
    }

    @Override
    protected void initializeLayout(Composite container) {
        super.initializeLayout(container);
        Section loggingLevelComposite = this.addCategoryLoggingLevelSection(container);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        loggingLevelComposite.setLayoutData((Object)gridData);
    }

    protected Section addCategoryLoggingLevelSection(Composite container) {
        final Section loggingSection = this.getWidgetFactory().createSection(container, 2);
        loggingSection.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CATEGORY_LOGGING_LEVEL_SECTION_TITLE);
        loggingSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && loggingSection.getClient() == null) {
                    loggingSection.setClient((Control)EclipseLinkLoggingComposite2_0.this.createCategoryLoggingLevelClient(loggingSection));
                }
            }
        });
        return loggingSection;
    }

    protected Composite createCategoryLoggingLevelClient(Section loggingSection) {
        Composite loggingClient = this.getWidgetFactory().createComposite((Composite)loggingSection);
        loggingClient.setLayout((Layout)new GridLayout(2, false));
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CACHE_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "cacheLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "connectionLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_DMS_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "dmsLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EJB_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "ejbLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EJB_OR_METADATA_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "ejb_or_metadataLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EVENT_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "eventLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_JPA_METAMODEL_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "jpa_metamodelLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_PROPAGATION_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "propagationLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_PROPERTIES_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "propertiesLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_QUERY_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "queryLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SEQUENCING_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "sequencingLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SERVER_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "serverLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SQL_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "sqlLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_TRANSACTION_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "transactionLoggingLevel");
        this.addLabel(loggingClient, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_WEAVER_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(loggingClient, "weaverLoggingLevel");
        return loggingClient;
    }

    @Override
    protected void logPropertiesComposite(Composite container) {
        super.logPropertiesComposite(container);
        TriStateCheckBox connectionCheckBox = this.addTriStateCheckBoxWithDefault(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LABEL, this.buildConnectionHolder(), this.buildConnectionStringHolder(), null);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        connectionCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private ModifiablePropertyValueModel<Boolean> buildConnectionHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging2_0, Boolean>(this.getSubjectHolder(), new String[]{"connection"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging2_0)this.subject).getConnection();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkLogging2_0)this.subject).setConnection(value);
            }
        };
    }

    private PropertyValueModel<String> buildConnectionStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultConnectionHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultConnectionHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging2_0, Boolean>(this.getSubjectHolder(), new String[]{"connection"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkLogging2_0)this.subject).getConnection() != null) {
                    return null;
                }
                return ((EclipseLinkLogging2_0)this.subject).getDefaultConnection();
            }
        };
    }

    protected EnumFormComboViewer<EclipseLinkLogging2_0, EclipseLinkLoggingLevel> addLoggingLevelCombo(Composite container, final String category) {
        return new EnumFormComboViewer<EclipseLinkLogging2_0, EclipseLinkLoggingLevel>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add(EclipseLinkLoggingComposite2_0.DEFAULT_PROPERTY);
                propertyNames.add("sqlLoggingLevel");
                propertyNames.add("transactionLoggingLevel");
                propertyNames.add("eventLoggingLevel");
                propertyNames.add("connectionLoggingLevel");
                propertyNames.add("queryLoggingLevel");
                propertyNames.add("cacheLoggingLevel");
                propertyNames.add("propagationLoggingLevel");
                propertyNames.add("sequencingLoggingLevel");
                propertyNames.add("ejbLoggingLevel");
                propertyNames.add("dmsLoggingLevel");
                propertyNames.add("ejb_or_metadataLoggingLevel");
                propertyNames.add("jpa_metamodelLoggingLevel");
                propertyNames.add("weaverLoggingLevel");
                propertyNames.add("propertiesLoggingLevel");
                propertyNames.add("serverLoggingLevel");
            }

            protected EclipseLinkLoggingLevel[] getChoices() {
                return EclipseLinkLoggingLevel.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected EclipseLinkLoggingLevel getDefaultValue() {
                return ((EclipseLinkLogging2_0)this.getSubject()).getCategoriesDefaultLevel();
            }

            protected String displayString(EclipseLinkLoggingLevel value) {
                switch (value) {
                    case all: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_ALL;
                    }
                    case config: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_CONFIG;
                    }
                    case fine: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINE;
                    }
                    case finer: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINER;
                    }
                    case finest: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINEST;
                    }
                    case info: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_INFO;
                    }
                    case off: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_OFF;
                    }
                    case severe: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_SEVERE;
                    }
                    case warning: {
                        return JptJpaEclipseLinkUiMessages.ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_WARNING;
                    }
                }
                throw new IllegalStateException();
            }

            protected EclipseLinkLoggingLevel getValue() {
                return ((EclipseLinkLogging2_0)this.getSubject()).getLevel(category);
            }

            protected void setValue(EclipseLinkLoggingLevel value) {
                ((EclipseLinkLogging2_0)this.getSubject()).setLevel(category, value);
            }

            protected void propertyChanged(String propertyName) {
                if (propertyName != category && propertyName != EclipseLinkLoggingComposite2_0.DEFAULT_PROPERTY) {
                    return;
                }
                super.propertyChanged(propertyName);
            }
        };
    }
}

