/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ProviderImpl;

public class AnnotationLookup {
    static final AnnotationProxy INJECT;
    static final AnnotationProxy SINGLETON;
    static final AnnotationProxy QUALIFIER;
    static final AnnotationProxy PRE_DESTROY;
    public static final AnnotationProxy POST_CONSTRUCT;
    static final AnnotationProxy OPTIONAL;
    private static final List<Class<?>> PROVIDER_TYPES;
    private static final ProviderFactory PROVIDER_FACTORY;
    private static final Map<Class<? extends Annotation>, Function<Annotation, String>> NAMED_ANNOTATION2VALUE_GETTER;
    private static boolean javaxWarningPrinted;

    static {
        ProviderFactory factory;
        INJECT = AnnotationLookup.createProxyForClasses(Inject.class, () -> javax.inject.Inject.class);
        SINGLETON = AnnotationLookup.createProxyForClasses(Singleton.class, () -> javax.inject.Singleton.class);
        QUALIFIER = AnnotationLookup.createProxyForClasses(Qualifier.class, () -> javax.inject.Qualifier.class);
        PRE_DESTROY = AnnotationLookup.createProxyForClasses(PreDestroy.class, () -> javax.annotation.PreDestroy.class);
        POST_CONSTRUCT = AnnotationLookup.createProxyForClasses(jakarta.annotation.PostConstruct.class, () -> PostConstruct.class);
        OPTIONAL = AnnotationLookup.createProxyForClasses(Optional.class, null);
        PROVIDER_TYPES = AnnotationLookup.getAvailableClasses(Provider.class, () -> javax.inject.Provider.class);
        try {
            class JavaxCompatibilityProviderImpl<T>
            extends ProviderImpl<T>
            implements javax.inject.Provider<T> {
                public JavaxCompatibilityProviderImpl(IObjectDescriptor descriptor, IInjector injector, PrimaryObjectSupplier provider) {
                    super(descriptor, injector, provider);
                }
            }
            factory = JavaxCompatibilityProviderImpl::new;
            factory.create(null, null, null);
        }
        catch (NoClassDefFoundError e) {
            factory = ProviderImpl::new;
        }
        PROVIDER_FACTORY = factory;
        HashMap<Class<Named>, Function<Annotation, String>> annotation2valueGetter = new HashMap<Class<Named>, Function<Annotation, String>>();
        annotation2valueGetter.put(Named.class, a -> ((Named)a).value());
        AnnotationLookup.loadJavaxClass(() -> {
            Function<Annotation, String> function = annotation2valueGetter.put(javax.inject.Named.class, a -> ((javax.inject.Named)a).value());
        });
        NAMED_ANNOTATION2VALUE_GETTER = Map.copyOf(annotation2valueGetter);
        javaxWarningPrinted = false;
    }

    private AnnotationLookup() {
    }

    private static AnnotationProxy createProxyForClasses(Class<? extends Annotation> jakartaAnnotationClass, Supplier<Class<? extends Annotation>> javaxAnnotationClass) {
        List<Class<? extends Annotation>> classes;
        List<Class<? extends Annotation>> annotationClasses = classes = AnnotationLookup.getAvailableClasses(jakartaAnnotationClass, javaxAnnotationClass);
        return new AnnotationProxy(annotationClasses);
    }

    static boolean isProvider(Type type) {
        for (Class<?> clazz : PROVIDER_TYPES) {
            if (!clazz.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Object getProvider(IObjectDescriptor descriptor, IInjector injector, PrimaryObjectSupplier provider) {
        return PROVIDER_FACTORY.create(descriptor, injector, provider);
    }

    public static String getQualifierValue(IObjectDescriptor descriptor) {
        Set<Map.Entry<Class<? extends Annotation>, Function<Annotation, String>>> annotations = NAMED_ANNOTATION2VALUE_GETTER.entrySet();
        for (Map.Entry<Class<? extends Annotation>, Function<Annotation, String>> entry : annotations) {
            Class<? extends Annotation> annotationClass = entry.getKey();
            if (!descriptor.hasQualifier(annotationClass)) continue;
            Annotation namedAnnotation = descriptor.getQualifier(annotationClass);
            return entry.getValue().apply(namedAnnotation);
        }
        return null;
    }

    private static List<Class<?>> getAvailableClasses(Class<?> jakartaClass, Supplier<? extends Class<?>> javaxClass) {
        ArrayList classes = new ArrayList();
        classes.add(jakartaClass);
        if (javaxClass != null) {
            AnnotationLookup.loadJavaxClass(() -> {
                boolean bl = classes.add((Class)javaxClass.get());
            });
        }
        return classes;
    }

    private static void loadJavaxClass(Runnable run) {
        try {
            if (!AnnotationLookup.getSystemPropertyFlag("eclipse.e4.inject.javax.disabled", false)) {
                run.run();
                if (!javaxWarningPrinted) {
                    if (AnnotationLookup.getSystemPropertyFlag("eclipse.e4.inject.javax.warning", true)) {
                        String message = "WARNING: Annotation classes from the 'javax.inject' or 'javax.annotation' package found.\nIt is recommended to migrate to the corresponding replacements in the jakarta namespace.\nThe Eclipse E4 Platform will remove support for those javax-annotations in a future release.\nTo suppress this warning, set the VM property: -Declipse.e4.inject.javax.warning=false\nTo disable processing of 'javax' annotations entirely, set the VM property: -Declipse.e4.inject.javax.disabled=true\n";
                        System.err.println(message);
                    }
                    javaxWarningPrinted = true;
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static boolean getSystemPropertyFlag(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        return value == null ? defaultValue : value.isEmpty() || Boolean.parseBoolean(value);
    }

    public record AnnotationProxy(List<Class<? extends Annotation>> classes) {
        public AnnotationProxy {
            classes = List.copyOf(classes);
        }

        public boolean isPresent(AnnotatedElement element) {
            for (Class<? extends Annotation> annotationClass : this.classes) {
                if (!element.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    private static interface ProviderFactory {
        public Object create(IObjectDescriptor var1, IInjector var2, PrimaryObjectSupplier var3);
    }
}

