/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ResourcesHelper;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class EditingDomainViewerDropAdapter
extends DropTargetAdapter {
    protected static final boolean IS_MOTIF = "motif".equals(SWT.getPlatform());
    protected Viewer viewer;
    protected EditingDomain domain;
    protected Collection<?> source;
    protected Command command;
    protected Object commandTarget;
    protected int originalOperation;
    protected DragAndDropCommandInformation dragAndDropCommandInformation;

    public EditingDomainViewerDropAdapter(EditingDomain domain, Viewer viewer) {
        this.viewer = viewer;
        this.domain = domain;
    }

    public void dragEnter(DropTargetEvent event) {
        this.originalOperation = event.detail;
        this.helper(event);
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
            this.commandTarget = null;
        }
        this.source = null;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.originalOperation = event.detail;
        this.helper(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.helper(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.helper(event);
    }

    public void drop(DropTargetEvent event) {
        if (this.dragAndDropCommandInformation != null) {
            this.command = this.dragAndDropCommandInformation.createCommand();
        } else {
            this.source = this.extractDragSource(event.data);
            Object target = this.extractDropTarget(event.item);
            this.command = DragAndDropCommand.create((EditingDomain)this.domain, (Object)target, (float)this.getLocation(event), (int)event.operations, (int)this.originalOperation, this.source);
        }
        if (this.command.canExecute()) {
            this.domain.getCommandStack().execute(this.command);
        } else {
            event.detail = 0;
            this.command.dispose();
        }
        this.command = null;
        this.commandTarget = null;
        this.source = null;
        this.dragAndDropCommandInformation = null;
    }

    protected void helper(DropTargetEvent event) {
        event.feedback = 1 | this.getAutoFeedback();
        if (this.source == null) {
            this.source = this.getDragSource(event);
            if (this.source == null) {
                this.dragAndDropCommandInformation = null;
                return;
            }
        }
        Object target = this.extractDropTarget(event.item);
        float location = this.getLocation(event);
        boolean valid = false;
        if (this.command == null) {
            this.dragAndDropCommandInformation = new DragAndDropCommandInformation(this.domain, target, location, event.operations, this.originalOperation, this.source);
            this.commandTarget = target;
            this.command = this.dragAndDropCommandInformation.createCommand();
            valid = this.command.canExecute();
        } else if (target == this.commandTarget && this.command instanceof DragAndDropFeedback) {
            valid = ((DragAndDropFeedback)this.command).validate(target, location, event.operations, this.originalOperation, this.source);
            this.dragAndDropCommandInformation = new DragAndDropCommandInformation(this.domain, target, location, event.operations, this.originalOperation, this.source);
        } else {
            this.dragAndDropCommandInformation = new DragAndDropCommandInformation(this.domain, target, location, event.operations, this.originalOperation, this.source);
            this.commandTarget = target;
            this.command.dispose();
            this.command = this.dragAndDropCommandInformation.createCommand();
            valid = this.command.canExecute();
        }
        if (this.command instanceof DragAndDropFeedback) {
            DragAndDropFeedback dragAndDropFeedback = (DragAndDropFeedback)this.command;
            event.detail = dragAndDropFeedback.getOperation();
            event.feedback = dragAndDropFeedback.getFeedback() | this.getAutoFeedback();
        } else if (!valid) {
            event.detail = 0;
        }
    }

    protected int getAutoFeedback() {
        return 24;
    }

    protected Collection<?> getDragSource(DropTargetEvent event) {
        TransferData transferData;
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        if (localTransfer.isSupportedType(event.currentDataType)) {
            if (IS_MOTIF) {
                return null;
            }
            Object object = localTransfer.nativeToJava(event.currentDataType);
            return object == null ? null : this.extractDragSource(object);
        }
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        if (localSelectionTransfer.isSupportedType(event.currentDataType)) {
            if (IS_MOTIF) {
                return null;
            }
            Object object = localSelectionTransfer.nativeToJava(event.currentDataType);
            return object == null ? null : this.extractDragSource(object);
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        if (fileTransfer.isSupportedType(event.currentDataType)) {
            if (IS_MOTIF) {
                return null;
            }
            Object object = fileTransfer.nativeToJava(event.currentDataType);
            return object == null ? null : this.extractDragSource(object);
        }
        TransferData[] dataTypes = event.dataTypes;
        int i = 0;
        while (i < dataTypes.length) {
            transferData = dataTypes[i];
            if (localTransfer.isSupportedType(transferData)) {
                event.currentDataType = transferData;
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < dataTypes.length) {
            transferData = dataTypes[i];
            if (localSelectionTransfer.isSupportedType(transferData)) {
                event.currentDataType = transferData;
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < dataTypes.length) {
            transferData = dataTypes[i];
            if (fileTransfer.isSupportedType(transferData)) {
                event.currentDataType = transferData;
                return null;
            }
            ++i;
        }
        return null;
    }

    protected Collection<?> extractDragSource(Object object) {
        if (object instanceof IStructuredSelection) {
            List<?> list = ((IStructuredSelection)object).toList();
            if (CommonPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                list = ResourcesHelper.resourceToURI(list);
            }
            return list;
        }
        if (object instanceof String[]) {
            ArrayList<URI> result = new ArrayList<URI>();
            String[] stringArray = (String[])object;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                result.add(URI.createFileURI((String)file));
                ++n2;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    protected Object extractDropTarget(Widget item) {
        if (item == null) {
            return null;
        }
        return item.getData();
    }

    protected float getLocation(DropTargetEvent event) {
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        if (event.item instanceof TableItem) {
            TableItem tableItem = (TableItem)event.item;
            Table control = tableItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = tableItem.getBounds(0);
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        return 0.0f;
    }

    protected static class DragAndDropCommandInformation {
        protected EditingDomain domain;
        protected Object target;
        protected float location;
        protected int operations;
        protected int operation;
        protected Collection<?> source;

        public DragAndDropCommandInformation(EditingDomain domain, Object target, float location, int operations, int operation, Collection<?> source) {
            this.domain = domain;
            this.target = target;
            this.location = location;
            this.operations = operations;
            this.operation = operation;
            this.source = new ArrayList(source);
        }

        public Command createCommand() {
            return DragAndDropCommand.create((EditingDomain)this.domain, (Object)this.target, (float)this.location, (int)this.operations, (int)this.operation, this.source);
        }
    }
}

