/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.PortComponentImpl;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.ServiceImplBeanImpl;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractObjectSelectionLaunchable;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaBeanSelectionLaunchable
extends AbstractObjectSelectionLaunchable {
    private IProject serverProject_ = null;
    private String serverComponentName_ = null;
    private String beanClassString_ = "";
    private IStatus validationStatus;

    @Override
    public void setInitialSelection(IStructuredSelection initialSelection) {
        if (initialSelection != null && !initialSelection.isEmpty()) {
            Object object = initialSelection.getFirstElement();
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                String fileExt = iFile.getFileExtension().toLowerCase();
                if (fileExt.equals("java") || fileExt.equals("class")) {
                    this.setBeanClass((IResource)iFile);
                }
            } else if (object instanceof IType) {
                this.setBeanClass((IType)object);
            } else if (object instanceof ICompilationUnit) {
                this.setBeanClass(((ICompilationUnit)object).getResource());
            } else if (object instanceof ServiceImplBeanImpl) {
                this.setBeanClass((ServiceImplBeanImpl)object);
            } else if (object instanceof BeanLink) {
                this.setBeanClass((BeanLink)object);
            } else if (object instanceof String) {
                this.beanClassString_ = (String)object;
            }
        }
    }

    @Override
    public IStructuredSelection getObjectSelection() {
        return new StructuredSelection((Object)this.beanClassString_);
    }

    @Override
    public IProject getProject() {
        return this.serverProject_;
    }

    @Override
    public String getComponentName() {
        return this.serverComponentName_;
    }

    @Override
    public int launch(Shell shell) {
        IType itype = DialogUtils.browseClassesAsIType((Shell)shell, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), (IRunnableContext)new ProgressMonitorDialog(shell));
        return this.setBeanClass(itype);
    }

    private int setBeanClass(IType itype) {
        if (itype != null) {
            this.beanClassString_ = itype.getFullyQualifiedName();
            try {
                IResource res = itype.getUnderlyingResource();
                if (res != null) {
                    this.serverProject_ = res.getProject();
                    IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)res);
                    if (comp != null) {
                        this.serverComponentName_ = comp.getName();
                    }
                } else {
                    this.serverProject_ = null;
                    this.serverComponentName_ = null;
                }
                return 0;
            }
            catch (JavaModelException javaModelException) {
                this.serverProject_ = null;
                this.serverComponentName_ = null;
                return 4;
            }
        }
        return 8;
    }

    private void setBeanClass(IResource resource) {
        IPath path;
        String basename;
        if (resource != null && resource instanceof IFile && (basename = (path = resource.getFullPath()).lastSegment()) != null && basename.length() > 0) {
            String beanClass;
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null || beanPackage.length() == 0 ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
            this.beanClassString_ = beanClass;
            this.serverProject_ = ResourceUtils.getProjectOf((IPath)path);
            IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
            if (comp != null) {
                this.serverComponentName_ = comp.getName();
            }
        }
    }

    private void setBeanClass(ServiceImplBeanImpl serviceImpl) {
        EObject eObject;
        if (serviceImpl != null && (eObject = serviceImpl.eContainer()) instanceof PortComponentImpl) {
            PortComponentImpl pci = (PortComponentImpl)eObject;
            this.beanClassString_ = pci.getServiceEndpointInterface();
        }
    }

    private void setBeanClass(BeanLink serviceImpl) {
        EObject eObject;
        if (serviceImpl != null && (eObject = serviceImpl.eContainer()) instanceof ServiceImplBeanImpl) {
            this.setBeanClass((ServiceImplBeanImpl)eObject);
        }
    }

    public IStatus getStatus() {
        if (this.beanClassString_.length() <= 0) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_BEAN_CANNOT_BE_EMPTY);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateSelection(IStructuredSelection objectSelection) {
        if (this.validationStatus == null) {
            return Status.OK_STATUS;
        }
        return this.validationStatus;
    }

    @Override
    public String getObjectSelectionDisplayableString() {
        return this.beanClassString_;
    }

    @Override
    public boolean validate(String s) {
        this.beanClassString_ = s;
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        this.validationStatus = JavaConventions.validateJavaTypeName((String)s, (String)sourceLevel, (String)complianceLevel);
        return this.validationStatus.isOK();
    }
}

