/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.queue;

import org.eclipse.jpt.common.utility.internal.queue.AbstractArrayQueue;

public class ArrayQueue<E>
extends AbstractArrayQueue<E> {
    private static final long serialVersionUID = 1L;

    public ArrayQueue(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void enqueue(E element) {
        this.ensureCapacity(this.size + 1);
        super.enqueue(element);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.elements.length < minCapacity) {
            int newCapacity = (this.elements.length * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
            this.head = 0;
            this.tail = this.size;
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size) {
            this.elements = this.copyElements(this.size);
            this.head = 0;
            this.tail = this.size;
        }
    }

    @Override
    public ArrayQueue<E> clone() {
        return (ArrayQueue)super.clone();
    }
}

