/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.environment;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.FileAsFileHandle;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.environment.IFileStoreProvider;

public class FileHandles {
    public static IFileStore asFileStore(IFileHandle handle) throws CoreException {
        if (handle instanceof IFileStoreProvider) {
            return ((IFileStoreProvider)((Object)handle)).getFileStore();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", "Unsupported " + String.valueOf(handle.getFullPath())));
    }

    public static File asFile(IFileHandle handle) throws CoreException {
        if (handle instanceof FileAsFileHandle) {
            return ((FileAsFileHandle)handle).getFile();
        }
        if ("org.eclipse.dltk.core.environment.localEnvironment".equals(handle.getEnvironmentId())) {
            return handle.getPath().toFile();
        }
        File result = FileHandles.asFileStore(handle).toLocalFile(0, null);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", "Unsupported " + String.valueOf(handle.getFullPath())));
        }
        return result;
    }

    public static IPath asPath(IFileHandle handle, IEnvironment environment) throws CoreException {
        if (environment.getId().equals(handle.getEnvironmentId())) {
            return handle.getPath();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", "Couldn't resolve " + String.valueOf(handle.getFullPath()) + " for " + environment.getName()));
    }
}

