/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter.profile;

import java.util.Collections;
import java.util.Map;
import org.eclipse.dltk.formatter.profile.Profile;
import org.eclipse.dltk.ui.formatter.IProfile;

public class BuiltInProfile
extends Profile {
    private final String fName;
    private final String fID;
    private final Map<String, String> fSettings;
    private final int fOrder;
    private final int fCurrentVersion;
    private final String fFormatter;

    public BuiltInProfile(String ID, String name, Map<String, String> settings, int order, String formatter, int currentVersion) {
        this.fName = name;
        this.fID = ID;
        this.fSettings = Collections.unmodifiableMap(settings);
        this.fOrder = order;
        this.fFormatter = formatter;
        this.fCurrentVersion = currentVersion;
    }

    public String getName() {
        return this.fName;
    }

    public Map<String, String> getSettings() {
        return this.fSettings;
    }

    public void setSettings(Map<String, String> settings) {
    }

    public String getID() {
        return this.fID;
    }

    public final int compareTo(IProfile o) {
        if (o instanceof BuiltInProfile) {
            return this.fOrder - ((BuiltInProfile)o).fOrder;
        }
        return -1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fName + "]";
    }

    public boolean isProfileToSave() {
        return false;
    }

    @Override
    public boolean isBuiltInProfile() {
        return true;
    }

    public int getVersion() {
        return this.fCurrentVersion;
    }

    public String getFormatterId() {
        return this.fFormatter;
    }
}

