/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Binding;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;
import org.eclipse.wst.wsdl.ui.internal.dialogs.W11BrowseComponentDialog;
import org.eclipse.wst.wsdl.ui.internal.dialogs.W11NewComponentDialog;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLImportManager;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLSetComponentHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;

public class W11InterfaceReferenceEditManager
implements ComponentReferenceEditManager {
    protected W11Description description;
    protected IFile iFile;

    public W11InterfaceReferenceEditManager(W11Description description, IFile iFile) {
        this.description = description;
        this.iFile = iFile;
    }

    public IComponentDialog getBrowseDialog() {
        return new W11BrowseComponentDialog(IWSDLSearchConstants.PORT_TYPE_META_NAME, this.iFile, this.description);
    }

    public IComponentDialog getNewDialog() {
        return new W11NewComponentDialog(IWSDLSearchConstants.PORT_TYPE_META_NAME, this.iFile, this.description);
    }

    private Definition getDefinition() {
        return (Definition)this.description.getTarget();
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification referencedComponent) {
        W11Binding w11Binding = (W11Binding)referencingObject;
        Object interfaceObject = referencedComponent.getObject();
        if (interfaceObject instanceof ComponentSpecification) {
            Binding binding = (Binding)w11Binding.getTarget();
            WSDLSetComponentHelper helper = new WSDLSetComponentHelper(this.iFile, this.getDefinition());
            helper.setWSDLComponent((WSDLElement)binding, "type", (ComponentSpecification)interfaceObject);
        } else if (interfaceObject instanceof IInterface) {
            IInterface interfaze = (IInterface)interfaceObject;
            Command command = w11Binding.getSetInterfaceCommand(interfaze);
            CommandStack stack = (CommandStack)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(CommandStack.class);
            stack.execute(command);
            WSDLImportManager.removeUnusedImports(this.getDefinition());
        }
    }

    public IComponentDescriptionProvider getComponentDescriptionProvider() {
        return null;
    }

    public ComponentSpecification[] getQuickPicks() {
        ArrayList<ComponentSpecification> specList = new ArrayList<ComponentSpecification>();
        for (IInterface interfaze : this.description.getInterfaces()) {
            String qualifier = "";
            String name = interfaze.getName();
            IFile file = null;
            ComponentSpecification spec = new ComponentSpecification(qualifier, name, file);
            spec.setObject((Object)interfaze);
            specList.add(spec);
        }
        ComponentSpecification[] specArray = new ComponentSpecification[specList.size()];
        specList.toArray(specArray);
        return specArray;
    }

    public ComponentSpecification[] getHistory() {
        ComponentSpecification[] history = new ComponentSpecification[]{};
        return history;
    }

    public void addToHistory(ComponentSpecification component) {
    }
}

