/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.typing.AbstractCharacterPairInserter;

public class CharacterPairInserter
extends AbstractCharacterPairInserter
implements IPropertyChangeListener {
    private boolean fCloseStrings = true;
    private boolean fCloseBrackets = true;

    protected boolean shouldPair(ISourceViewer viewer, char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return this.fCloseStrings ? this.checkRegion(viewer, c) : false;
            }
        }
        return this.fCloseBrackets;
    }

    private boolean checkRegion(ISourceViewer viewer, char c) {
        ITextRegion region;
        IStructuredDocumentRegion[] regions;
        IDocument doc = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        int offset = selection.x;
        if (doc instanceof IStructuredDocument && (regions = ((IStructuredDocument)doc).getStructuredDocumentRegions(offset, 0)) != null && regions.length > 0 && (region = regions[0].getRegionAtCharacterOffset(offset)) != null) {
            String type = region.getType();
            if ("XML_TAG_ATTRIBUTE_EQUALS".equals(type)) {
                return true;
            }
            if (("XML_TAG_CLOSE".equals(type) || "XML_EMPTY_TAG_CLOSE".equals(type)) && regions[0].containsOffset(offset - 1) && (region = regions[0].getRegionAtCharacterOffset(offset - 1)) != null && "XML_TAG_ATTRIBUTE_EQUALS".equals(region.getType())) {
                return true;
            }
            return c != '\'' && "XML_CONTENT".equals(type);
        }
        return true;
    }

    public boolean hasPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '(': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    protected char getPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return c;
            }
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
        }
        throw new IllegalArgumentException();
    }

    public void initialize() {
        IPreferenceStore store = HTMLUIPlugin.getInstance().getPreferenceStore();
        this.fCloseStrings = store.getBoolean("closeStrings");
        this.fCloseBrackets = store.getBoolean("closeBrackets");
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        HTMLUIPlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("closeBrackets".equals(event.getProperty())) {
            this.fCloseBrackets = (Boolean)event.getNewValue();
        } else if ("closeStrings".equals(event.getProperty())) {
            this.fCloseStrings = (Boolean)event.getNewValue();
        }
    }
}

