/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.identity;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public class ServiceTypeID
extends BaseID
implements IServiceTypeID {
    private static final long serialVersionUID = 2546630451825262145L;
    protected static final String DELIM = "._";
    protected String typeName = "";
    protected String namingAuthority;
    protected String[] protocols;
    protected String[] scopes;
    protected String[] services;

    protected ServiceTypeID(Namespace namespace) {
        super(namespace);
    }

    protected ServiceTypeID(Namespace namespace, String[] services, String[] scopes, String[] protocols, String namingAuthority) {
        super(namespace);
        Assert.isNotNull((Object)services);
        this.services = services;
        Assert.isNotNull((Object)scopes);
        this.scopes = scopes;
        Assert.isNotNull((Object)protocols);
        this.protocols = protocols;
        Assert.isNotNull((Object)namingAuthority);
        this.namingAuthority = namingAuthority;
        this.createType();
        Assert.isNotNull((Object)this.typeName);
    }

    protected ServiceTypeID(Namespace ns, IServiceTypeID id) {
        this(ns, id.getServices(), id.getScopes(), id.getProtocols(), id.getNamingAuthority());
    }

    public ServiceTypeID(Namespace namespace, String aType) {
        this(namespace);
        if (aType != null) {
            try {
                int lastUnderscore;
                int lastDot;
                aType = aType.trim();
                if (aType.endsWith(".")) {
                    aType = aType.substring(0, aType.length() - 1);
                }
                if ((lastDot = aType.lastIndexOf(46)) + 1 != (lastUnderscore = aType.lastIndexOf(95))) {
                    aType = String.valueOf(aType) + DELIM + "iana";
                }
                String type = aType.substring(1);
                String[] split = StringUtils.split((String)type, (String)DELIM);
                int offset = split.length - 1;
                this.namingAuthority = split[offset];
                String string = split[--offset];
                String[] protoAndScope = StringUtils.split((String)string, (String)".", (int)(string.indexOf(".") - 1));
                this.protocols = new String[]{protoAndScope[0]};
                this.scopes = new String[]{protoAndScope[1]};
                List<String> subList = Arrays.asList(split).subList(0, offset);
                this.services = subList.toArray(new String[0]);
                this.createType();
                Assert.isTrue((boolean)aType.equals(this.typeName));
            }
            catch (Exception e) {
                throw new IDCreateException("service type not parseable", (Throwable)e);
            }
        } else {
            throw new IDCreateException("service type cannot be null");
        }
    }

    protected void createType() {
        StringBuffer buf = new StringBuffer();
        buf.append("_");
        int i = 0;
        while (i < this.services.length) {
            buf.append(this.services[i]);
            buf.append(DELIM);
            ++i;
        }
        i = 0;
        while (i < this.protocols.length) {
            buf.append(this.protocols[i]);
            if (i != this.protocols.length - 1) {
                buf.append(DELIM);
            } else {
                buf.append(".");
            }
            ++i;
        }
        i = 0;
        while (i < this.scopes.length) {
            buf.append(this.scopes[i]);
            buf.append(DELIM);
            ++i;
        }
        buf.append(this.namingAuthority);
        this.typeName = buf.toString();
    }

    public String getName() {
        return this.typeName;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o instanceof ServiceTypeID) {
            ServiceTypeID other = (ServiceTypeID)o;
            String typename = other.getName();
            return this.getName().compareTo(typename);
        }
        return 1;
    }

    protected boolean namespaceEquals(BaseID o) {
        ServiceTypeID other;
        if (o == null) {
            return false;
        }
        return o instanceof ServiceTypeID && (other = (ServiceTypeID)o).getName().equals(this.getName());
    }

    protected String namespaceGetName() {
        return this.typeName;
    }

    protected int namespaceHashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceTypeID[");
        buf.append("typeName=").append(this.typeName).append("]");
        return buf.toString();
    }

    @Override
    public String getNamingAuthority() {
        return this.namingAuthority;
    }

    @Override
    public String[] getProtocols() {
        return this.protocols;
    }

    @Override
    public String[] getScopes() {
        return this.scopes;
    }

    @Override
    public String[] getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IServiceTypeID)) {
            return false;
        }
        ServiceTypeID stid = (ServiceTypeID)o;
        return stid.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getInternal() {
        return this.typeName;
    }
}

