/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.propertypage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.propertypage.AbstractIModuleDependenciesControl;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;
import org.eclipse.wst.common.componentcore.ui.propertypage.IDependencyPageProvider;
import org.eclipse.wst.common.componentcore.ui.propertypage.IModuleDependenciesControl;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ModuleAssemblyRootPage
extends PropertyPage {
    private IProject project;
    private IModuleDependenciesControl[] controls = new IModuleDependenciesControl[0];
    private SashForm sform1;
    private Composite topComposite;
    private ScrolledComposite problemsViewComposite;
    private Composite subProblemsViewComposite;

    private Composite getFacetErrorComposite(Composite parent) {
        String errorCheckingFacet = Messages.ErrorCheckingFacets;
        this.setErrorMessage(errorCheckingFacet);
        return this.getErrorComposite(parent, errorCheckingFacet);
    }

    private Composite getVirtCompErrorComposite(Composite parent) {
        String errorCheckingFacet = Messages.ErrorNotVirtualComponent;
        this.setErrorMessage(errorCheckingFacet);
        return this.getErrorComposite(parent, errorCheckingFacet);
    }

    private Composite getErrorComposite(Composite parent, String error) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(error);
        return composite;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && !this.controls[i].performOk()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.controls[i].performDefaults();
            }
            ++i;
        }
    }

    public void performApply() {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.controls[i].performApply();
            }
            ++i;
        }
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && !this.controls[i].performCancel()) {
                return false;
            }
            ++i;
        }
        return super.performCancel();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.controls[i].setVisible(visible);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.controls[i].dispose();
            }
            ++i;
        }
    }

    protected static void createDescriptionComposite(Composite parent, String description) {
        Composite descriptionComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        descriptionComp.setLayout((Layout)layout);
        descriptionComp.setLayoutData((Object)new GridData(768));
        ModuleAssemblyRootPage.fillDescription(descriptionComp, description);
    }

    private static void fillDescription(Composite c, String s) {
        GridData data = new GridData(768);
        data.widthHint = 250;
        Text label = new Text(c, 72);
        label.setBackground(c.getBackground());
        label.setLayoutData((Object)data);
        label.setText(s);
    }

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        if (this.project != null) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
                IDependencyPageProvider provider = null;
                if (facetedProject == null) {
                    return this.getFacetErrorComposite(parent);
                }
                provider = DependencyPageExtensionManager.getManager().getProvider(facetedProject);
                if (provider != null) {
                    this.controls = provider.createPages(facetedProject, this);
                    IModuleDependenciesControl[] iModuleDependenciesControlArray = this.controls = this.controls == null ? new IModuleDependenciesControl[]{} : this.controls;
                    if (provider.getPageTitle(this.project) != null) {
                        this.setTitle(provider.getPageTitle(this.project));
                    }
                    this.sform1 = new SashForm(parent, 66048);
                    GridData gd1 = new GridData(16384, 4, false, false);
                    this.sform1.setLayoutData((Object)gd1);
                    this.topComposite = provider.createRootControl(facetedProject, this.controls, (Composite)this.sform1);
                } else {
                    if (ComponentCore.createComponent((IProject)this.project) == null) {
                        return this.getVirtCompErrorComposite(parent);
                    }
                    AddModuleDependenciesPropertiesPage page = new AddModuleDependenciesPropertiesPage(this.project, this);
                    this.controls = new IModuleDependenciesControl[1];
                    this.controls[0] = page;
                    this.sform1 = new SashForm(parent, 66048);
                    GridData gd1 = new GridData(16384, 4, false, false);
                    this.sform1.setLayoutData((Object)gd1);
                    this.topComposite = page.createContents((Composite)this.sform1);
                }
                this.problemsViewComposite = new ScrolledComposite((Composite)this.sform1, 2816);
                GridData gd = new GridData();
                gd.heightHint = 100;
                gd.horizontalAlignment = 4;
                gd.verticalAlignment = 1024;
                this.problemsViewComposite.setLayoutData((Object)gd);
                this.problemsViewComposite.setBackground(Display.getDefault().getSystemColor(1));
                this.fillProblemsViewComposite();
                this.sform1.setWeights(new int[]{80, 20});
                this.problemsViewComposite.addListener(11, new Listener(){

                    public void handleEvent(Event e) {
                        ModuleAssemblyRootPage.this.handleProblemsViewResize();
                    }
                });
                return this.sform1;
            }
            catch (CoreException coreException) {}
        }
        return this.getFacetErrorComposite(parent);
    }

    private void handleProblemsViewResize() {
        if (this.subProblemsViewComposite != null && !this.subProblemsViewComposite.isDisposed() && this.topComposite != null) {
            int width = this.topComposite.getClientArea().width;
            if (width < 400) {
                width = 400;
            }
            int i = 1;
            Control[] controlArray = this.subProblemsViewComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (i % 2 == 0) {
                    GridData gd = (GridData)child.getLayoutData();
                    gd.widthHint = width - 50;
                }
                ++i;
                ++n2;
            }
            this.subProblemsViewComposite.setSize(this.subProblemsViewComposite.computeSize(-1, -1));
            this.subProblemsViewComposite.update();
        }
    }

    protected void fillProblemsViewComposite() {
        if (this.problemsViewComposite != null) {
            IStatus[] problems = this.getProblemElements();
            if (problems != null && problems.length > 0) {
                boolean resize = false;
                Control[] controlArray = this.problemsViewComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    resize = true;
                    ++n2;
                }
                this.subProblemsViewComposite = new Composite((Composite)this.problemsViewComposite, 0);
                this.subProblemsViewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                this.subProblemsViewComposite.setLayout((Layout)ModuleAssemblyRootPage.glmargins(new GridLayout(2, false), 0, 0, 5, 5));
                this.subProblemsViewComposite.setBackground(Display.getDefault().getSystemColor(1));
                int width = 400;
                if (this.topComposite != null && this.topComposite.getClientArea().width > 400) {
                    width = this.topComposite.getClientArea().width;
                }
                Listener focusOnProblemListener = new Listener(){

                    public void handleEvent(Event e) {
                        Control problemLabel = (Control)e.widget;
                        Rectangle problemLabelBounds = problemLabel.getBounds();
                        Rectangle scrollableArea = ModuleAssemblyRootPage.this.problemsViewComposite.getClientArea();
                        Point currentScrollPosition = ModuleAssemblyRootPage.this.problemsViewComposite.getOrigin();
                        if (currentScrollPosition.y > problemLabelBounds.y) {
                            currentScrollPosition.y = Math.max(0, problemLabelBounds.y);
                        }
                        if (currentScrollPosition.y + scrollableArea.height < problemLabelBounds.y + problemLabelBounds.height) {
                            currentScrollPosition.y = Math.max(0, problemLabelBounds.y + problemLabelBounds.height - scrollableArea.height);
                        }
                        ModuleAssemblyRootPage.this.problemsViewComposite.setOrigin(currentScrollPosition);
                    }
                };
                int i = 0;
                while (i < problems.length) {
                    IStatus singleStatus = problems[i];
                    if (!singleStatus.isOK() && singleStatus.getMessage() != null) {
                        Label image = new Label(this.subProblemsViewComposite, 0);
                        GridData gdImage = new GridData();
                        gdImage.verticalAlignment = 1;
                        image.setBackground(Display.getDefault().getSystemColor(1));
                        image.setImage(this.getProblemImage(singleStatus));
                        image.setLayoutData((Object)gdImage);
                        Text text = new Text(this.subProblemsViewComposite, 72);
                        GridData gdLabel = new GridData();
                        gdLabel.widthHint = width - 50;
                        text.setBackground(Display.getDefault().getSystemColor(1));
                        text.setText(singleStatus.getMessage());
                        text.setLayoutData((Object)gdLabel);
                        text.addListener(26, focusOnProblemListener);
                    }
                    ++i;
                }
                this.problemsViewComposite.setContent((Control)this.subProblemsViewComposite);
                if (resize) {
                    this.handleProblemsViewResize();
                }
                if (this.sform1.getMaximizedControl() != null) {
                    this.sform1.setMaximizedControl(null);
                }
            } else {
                this.sform1.setMaximizedControl((Control)this.topComposite);
            }
        }
    }

    private static final GridLayout glmargins(GridLayout layout, int marginWidth, int marginHeight, int marginTop, int marginBottom) {
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = marginTop;
        layout.marginBottom = marginBottom;
        return layout;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button defaultButton = this.getDefaultsButton();
        defaultButton.setText(Messages.Revert);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Object layoutData = defaultButton.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)defaultButton.getLayoutData();
            Point minButtonSize = defaultButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minButtonSize.x);
            defaultButton.setLayoutData((Object)data);
        }
    }

    public void refreshProblemsView() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
        this.fillProblemsViewComposite();
    }

    private Image getProblemImage(IStatus element) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        String imageType = element.getSeverity() == 4 ? "IMG_OBJS_ERROR_TSK" : (element.getSeverity() == 1 ? "IMG_OBJS_INFO_TSK" : "IMG_OBJS_WARN_TSK");
        return sharedImages.getImage(imageType);
    }

    protected IStatus[] getProblemElements() {
        ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList<IStatus> warnings = new ArrayList<IStatus>();
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                IStatus status = Status.OK_STATUS;
                if (this.controls[i] instanceof AbstractIModuleDependenciesControl) {
                    status = ((AbstractIModuleDependenciesControl)this.controls[i]).validate();
                }
                if (status != null) {
                    if (status.isMultiStatus()) {
                        MultiStatus multi = (MultiStatus)status;
                        if (!multi.isOK()) {
                            int y = 0;
                            while (y < multi.getChildren().length) {
                                IStatus singleStatus = multi.getChildren()[y];
                                if (singleStatus.getMessage() != null && singleStatus.getMessage().trim().length() > 0) {
                                    if (multi.getChildren()[y].getSeverity() == 4) {
                                        errors.add(multi.getChildren()[y]);
                                    } else {
                                        warnings.add(multi.getChildren()[y]);
                                    }
                                }
                                ++y;
                            }
                        }
                    } else if (!status.isOK() && status.getMessage() != null && status.getMessage().trim().length() > 0) {
                        if (status.getSeverity() == 4) {
                            errors.add(status);
                        } else {
                            warnings.add(status);
                        }
                    }
                }
            }
            ++i;
        }
        if (errors.size() > 0) {
            this.setValid(false);
            errors.addAll(warnings);
            return errors.toArray(new IStatus[errors.size()]);
        }
        return warnings.toArray(new IStatus[warnings.size()]);
    }
}

