/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.lucene103.blocktree.IntersectTermsEnum;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene103.blocktree.SegmentTermsEnum;
import org.apache.lucene.codecs.lucene103.blocktree.Stats;
import org.apache.lucene.codecs.lucene103.blocktree.TrieReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class FieldReader
extends Terms {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final long indexStart;
    final long rootFP;
    final long indexEnd;
    final Lucene103BlockTreeTermsReader parent;
    final IndexInput indexIn;

    FieldReader(Lucene103BlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount, IndexInput metaIn, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.indexStart = metaIn.readVLong();
        this.rootFP = metaIn.readVLong();
        this.indexEnd = metaIn.readVLong();
        this.indexIn = indexIn;
    }

    private TrieReader newReader() throws IOException {
        return new TrieReader(this.indexIn.slice("trie index", this.indexStart, this.indexEnd - this.indexStart), this.rootFP);
    }

    @Override
    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    @Override
    public Stats getStats() throws IOException {
        return new SegmentTermsEnum(this, this.newReader()).computeBlockStats();
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this, this.newReader());
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new IntersectTermsEnum(this, this.newReader(), compiled.getTransitionAccessor(), compiled.getByteRunnable(), compiled.commonSuffixRef, startTerm);
    }

    public String toString() {
        return "BlockTreeTerms(seg=" + this.parent.segment + " terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

