/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import jdk.test.lib.Asserts;

public class FileHelper {
    public static Path getDest(String subPath) throws IOException {
        Path path = Paths.get(subPath + "/test.jfr", new String[0]);
        Path parent = path.getParent();
        if (parent == null) {
            throw new IOException("No parent cound be found for path " + subPath);
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        return path;
    }

    public static Path createLongDir(Path root) throws IOException {
        int minPathLength = 400;
        StringBuilder buff = new StringBuilder();
        buff.append(root.toString());
        while (buff.length() < 400) {
            buff.append("/veryLongPath012345678901234567890123456789");
        }
        Path path = Paths.get(buff.toString(), new String[0]);
        System.out.println("long dir=" + String.valueOf(path));
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    public static Path getDestReadOnly(String subPath) throws IOException {
        Path path = FileHelper.getDest(subPath);
        Path parent = path.getParent();
        if (parent == null) {
            throw new IOException("No parent cound be found for path " + subPath);
        }
        parent.toFile().setReadOnly();
        return path;
    }

    public static Path createReadOnlyFile(Path path) throws IOException {
        Path createdPath = Files.createFile(path, new FileAttribute[0]);
        createdPath.toFile().setReadOnly();
        return createdPath;
    }

    public static Path createReadOnlyDir(Path path) throws IOException {
        Path createdPath = Files.createDirectories(path, new FileAttribute[0]);
        createdPath.toFile().setReadOnly();
        return createdPath;
    }

    public static Path getDestNotExist() {
        return Paths.get(".", "thisDirDoesNotExist/test.jfr");
    }

    public static boolean isReadOnlyPath(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Path f = Files.createFile(Paths.get(path.toString(), "dummyFileToCheckReadOnly"), new FileAttribute[0]);
                System.out.printf("Dir is not read-only, created %s, exists=%b%n", f, Files.exists(f, new LinkOption[0]));
                return false;
            }
            catch (AccessDeniedException e) {
                System.out.printf("'%s' verified read-only by %s%n", path, e.toString());
                return true;
            }
        }
        boolean isReadOnly = !Files.isWritable(path);
        System.out.format("isReadOnly '%s': %b%n", path, isReadOnly);
        return isReadOnly;
    }

    public static void verifyRecording(File file) throws Exception {
        Asserts.assertTrue(file.exists(), file.getAbsolutePath() + " does not exist");
        Asserts.assertTrue(file.isFile(), file.getAbsolutePath() + " is not a file");
        Asserts.assertGreaterThan(file.length(), 0L, "Size of recording is 0.");
        List<RecordedEvent> events = RecordingFile.readAllEvents(file.toPath());
        Iterator<RecordedEvent> iterator = events.iterator();
        if (iterator.hasNext()) {
            RecordedEvent event = iterator.next();
            System.out.printf("First event in recording '%s':%n%s", file.getName(), event);
            return;
        }
        Asserts.fail("No events in file " + file.getName());
    }
}

