/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jdk.test.lib.security.KeyStoreUtils;

public class SSLContextBuilder {
    private KeyStore trustStore = null;
    private KeyStore keyStore = null;
    private String tmfAlgo = TrustManagerFactory.getDefaultAlgorithm();
    private String kmfAlgo = KeyManagerFactory.getDefaultAlgorithm();
    private String kmfPassphrase = null;
    private String protocol = "TLS";
    private SecureRandom random = null;

    public SSLContextBuilder trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public SSLContextBuilder keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public SSLContextBuilder tmfAlgo(String tmfAlgo) {
        this.tmfAlgo = tmfAlgo;
        return this;
    }

    public SSLContextBuilder kmfAlgo(String kmfAlgo) {
        this.kmfAlgo = kmfAlgo;
        return this;
    }

    public SSLContextBuilder kmfPassphrase(String kmfPassphrase) {
        this.kmfPassphrase = kmfPassphrase;
        return this;
    }

    public SSLContextBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SSLContextBuilder random(SecureRandom random) {
        this.random = random;
        return this;
    }

    public SSLContext build() throws Exception {
        return SSLContextBuilder.buildSSLContext(this.trustStore, this.keyStore, this.tmfAlgo, this.kmfAlgo, this.kmfPassphrase, this.protocol, this.random);
    }

    public static SSLContextBuilder builder() {
        return new SSLContextBuilder();
    }

    public static SSLContext defaultTLSContext() throws Exception {
        return SSLContextBuilder.builder().trustStore(KeyStoreUtils.defaultTrustStore()).keyStore(KeyStoreUtils.defaultKeyStore()).build();
    }

    public static SSLContext defaultDTLSContext() throws Exception {
        return SSLContextBuilder.builder().trustStore(KeyStoreUtils.defaultTrustStore()).keyStore(KeyStoreUtils.defaultKeyStore()).protocol("DTLS").build();
    }

    private static SSLContext buildSSLContext(KeyStore trustStore, KeyStore keyStore, String tmfAlgo, String kmfAlgo, String kmfPassphrase, String protocol, SecureRandom random) throws Exception {
        TrustManagerFactory tmf = null;
        if (trustStore != null) {
            tmf = TrustManagerFactory.getInstance(tmfAlgo);
            tmf.init(trustStore);
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            kmf = KeyManagerFactory.getInstance(kmfAlgo);
            kmf.init(keyStore, kmfPassphrase == null ? null : kmfPassphrase.toCharArray());
        }
        SSLContext context = SSLContext.getInstance(protocol);
        context.init(kmf == null ? null : kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), random);
        return context;
    }
}

