/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;

public abstract class MetaInfMavenScanner<T> {
    private static final String POM_XML = "pom.xml";
    private static final String POM_PROPERTIES = "pom.properties";
    private static final String META_INF_MAVEN = "META-INF/maven";
    private static final MetaInfMavenScanner<ArtifactKey> PROERTIES_SCANNER = new MetaInfMavenScanner<ArtifactKey>(){

        @Override
        protected ArtifactKey visitFile(Path file) throws IOException {
            return this.loadPomProperties(Files.newInputStream(file, new OpenOption[0]), file);
        }

        @Override
        protected ArtifactKey visitJarEntry(JarFile jar, JarEntry entry) throws IOException {
            return this.loadPomProperties(jar.getInputStream(entry), Path.of(entry.getName(), new String[0]));
        }

        private ArtifactKey loadPomProperties(InputStream is, Path path) throws IOException {
            Properties properties = new Properties();
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                try {
                    properties.load(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            return MetaInfMavenScanner.createKey(groupId, artifactId, version, path, MetaInfMavenScanner.POM_PROPERTIES);
        }
    };
    private static final MetaInfMavenScanner<ArtifactKey> XML_SCANNER = new MetaInfMavenScanner<ArtifactKey>(){

        @Override
        protected ArtifactKey visitFile(Path file) throws IOException {
            return this.loadPomProperties(Files.newInputStream(file, new OpenOption[0]), file);
        }

        @Override
        protected ArtifactKey visitJarEntry(JarFile jar, JarEntry entry) throws IOException {
            return this.loadPomProperties(jar.getInputStream(entry), Path.of(entry.getName(), new String[0]));
        }

        private ArtifactKey loadPomProperties(InputStream is, Path path) throws IOException {
            String version;
            Model model;
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    try {
                        model = MavenPlugin.getMavenModelManager().readMavenModel(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException ex) {
                return null;
            }
            Parent parent = model.getParent();
            String groupId = model.getGroupId();
            if (groupId == null && parent != null) {
                groupId = parent.getGroupId();
            }
            if ((version = model.getVersion()) == null && parent != null) {
                version = parent.getVersion();
            }
            return MetaInfMavenScanner.createKey(groupId, model.getArtifactId(), version, path, MetaInfMavenScanner.POM_XML);
        }
    };

    private static ArtifactKey createKey(String groupId, String artifactId, String version, Path path, String source) {
        if (groupId != null && artifactId != null && version != null && path.endsWith(Path.of(groupId, artifactId, source))) {
            return new ArtifactKey(groupId, artifactId, version, null);
        }
        return null;
    }

    public List<T> scan(Path file, String filename) {
        ArrayList result;
        block13: {
            if (file == null) {
                return List.of();
            }
            result = new ArrayList();
            try {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.scanFilesystem(file.resolve(META_INF_MAVEN), filename, result);
                    break block13;
                }
                if (!Files.isRegularFile(file, new LinkOption[0])) break block13;
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jar = new JarFile(file.toFile());){
                    this.scanJar(jar, "/" + filename, result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private void scanJar(JarFile jar, String filename, List<T> result) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).startsWith(META_INF_MAVEN) || !name.endsWith(filename)) continue;
            try {
                T t = this.visitJarEntry(jar, entry);
                if (t == null) continue;
                result.add(t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void scanFilesystem(Path dir, final String filename, final List<T> result) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Object t;
                if (filename.equals(file.getFileName().toString()) && (t = MetaInfMavenScanner.this.visitFile(file)) != null) {
                    result.add(t);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected abstract T visitFile(Path var1) throws IOException;

    protected abstract T visitJarEntry(JarFile var1, JarEntry var2) throws IOException;

    public static Set<ArtifactKey> scanForPomProperties(Path classesLocation) {
        return new LinkedHashSet<ArtifactKey>(PROERTIES_SCANNER.scan(classesLocation, POM_PROPERTIES));
    }

    public static Set<ArtifactKey> scanForPomXml(Path classesLocation) {
        return new LinkedHashSet<ArtifactKey>(XML_SCANNER.scan(classesLocation, POM_XML));
    }
}

