/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Map;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.NodeMetaDataHandler;

public class ASTNode
implements NodeMetaDataHandler {
    private int _start;
    private int _until;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private int lastLineNumber = -1;
    private int lastColumnNumber = -1;
    private Map metaDataMap;

    public void visit(GroovyCodeVisitor visitor) {
        throw new RuntimeException("No visit() method implemented for class: " + this.getClass().getName());
    }

    public String getText() {
        Class<?> nodeType = this.getClass();
        if (nodeType.isAnonymousClass()) {
            nodeType = nodeType.getSuperclass();
        }
        return "<not implemented yet for class: " + nodeType.getName() + ">";
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getLastLineNumber() {
        return this.lastLineNumber;
    }

    public void setLastLineNumber(int lastLineNumber) {
        this.lastLineNumber = lastLineNumber;
    }

    public int getLastColumnNumber() {
        return this.lastColumnNumber;
    }

    public void setLastColumnNumber(int lastColumnNumber) {
        this.lastColumnNumber = lastColumnNumber;
    }

    public int getStart() {
        return this._start;
    }

    public void setStart(int offset) {
        this._start = Math.max(offset, -1);
    }

    public int getEnd() {
        return this._until;
    }

    public void setEnd(int offset) {
        this._until = Math.max(offset, -2);
    }

    public int getLength() {
        return this._until >= this._start ? this._until - this._start : -1;
    }

    public void setSourcePosition(ASTNode node) {
        this.lineNumber = node.getLineNumber();
        this.columnNumber = node.getColumnNumber();
        this.lastLineNumber = node.getLastLineNumber();
        this.lastColumnNumber = node.getLastColumnNumber();
        this._start = node.getStart();
        this._until = node.getEnd();
    }

    public void copyNodeMetaData(ASTNode other) {
        this.copyNodeMetaData((NodeMetaDataHandler)other);
    }

    public Map getMetaDataMap() {
        return this.metaDataMap;
    }

    public void setMetaDataMap(Map metaDataMap) {
        this.metaDataMap = metaDataMap;
    }
}

